/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.data;

import java.lang.annotation.Annotation;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.qubership.profiler.shaded.org.springframework.context.EnvironmentAware;
import org.qubership.profiler.shaded.org.springframework.context.ResourceLoaderAware;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.core.io.ResourceLoader;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.core.type.StandardAnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.qubership.profiler.shaded.org.springframework.data.repository.config.RepositoryConfigurationDelegate;
import org.qubership.profiler.shaded.org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.qubership.profiler.shaded.org.springframework.data.repository.config.RepositoryConfigurationSource;

public abstract class AbstractRepositoryConfigurationSourceSupport
implements BeanFactoryAware,
ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private BeanFactory beanFactory;
    private Environment environment;

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        new RepositoryConfigurationDelegate((RepositoryConfigurationSource)this.getConfigurationSource(), this.resourceLoader, this.environment).registerRepositoriesIn(registry, this.getRepositoryConfigurationExtension());
    }

    private AnnotationRepositoryConfigurationSource getConfigurationSource() {
        StandardAnnotationMetadata metadata = new StandardAnnotationMetadata(this.getConfiguration(), true);
        return new AnnotationRepositoryConfigurationSource(metadata, this.getAnnotation(), this.resourceLoader, this.environment){

            public Iterable<String> getBasePackages() {
                return AbstractRepositoryConfigurationSourceSupport.this.getBasePackages();
            }
        };
    }

    protected Iterable<String> getBasePackages() {
        return AutoConfigurationPackages.get(this.beanFactory);
    }

    protected abstract Class<? extends Annotation> getAnnotation();

    protected abstract Class<?> getConfiguration();

    protected abstract RepositoryConfigurationExtension getRepositoryConfigurationExtension();

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

