/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.data.neo4j;

import java.util.List;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.EventListener;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.data.neo4j.template.Neo4jOperations;
import org.qubership.profiler.shaded.org.springframework.data.neo4j.template.Neo4jTemplate;
import org.qubership.profiler.shaded.org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.qubership.profiler.shaded.org.springframework.data.neo4j.web.support.OpenSessionInViewInterceptor;
import org.qubership.profiler.shaded.org.springframework.transaction.PlatformTransactionManager;
import org.qubership.profiler.shaded.org.springframework.web.context.request.WebRequestInterceptor;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration
@AutoConfigureAfter(value={TransactionAutoConfiguration.class})
@ConditionalOnClass(value={SessionFactory.class, PlatformTransactionManager.class})
@ConditionalOnMissingBean(value={SessionFactory.class})
@EnableConfigurationProperties(value={Neo4jProperties.class})
public class Neo4jDataAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Configuration configuration(Neo4jProperties properties) {
        return properties.createConfiguration();
    }

    @Bean
    public SessionFactory sessionFactory(Configuration configuration, ApplicationContext applicationContext, ObjectProvider<List<EventListener>> eventListeners) {
        SessionFactory sessionFactory = new SessionFactory(configuration, this.getPackagesToScan(applicationContext));
        List<EventListener> providedEventListeners = eventListeners.getIfAvailable();
        if (providedEventListeners != null) {
            for (EventListener eventListener : providedEventListeners) {
                sessionFactory.register(eventListener);
            }
        }
        return sessionFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={Neo4jOperations.class})
    public Neo4jTemplate neo4jTemplate(SessionFactory sessionFactory) {
        return new Neo4jTemplate(sessionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public Neo4jTransactionManager transactionManager(SessionFactory sessionFactory, Neo4jProperties properties, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        return this.customize(new Neo4jTransactionManager(sessionFactory), transactionManagerCustomizers.getIfAvailable());
    }

    private Neo4jTransactionManager customize(Neo4jTransactionManager transactionManager, TransactionManagerCustomizers customizers) {
        if (customizers != null) {
            customizers.customize((PlatformTransactionManager)transactionManager);
        }
        return transactionManager;
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List<String> packages = EntityScanPackages.get(applicationContext).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has(applicationContext)) {
            packages = AutoConfigurationPackages.get(applicationContext);
        }
        return packages.toArray(new String[packages.size()]);
    }

    @org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={WebMvcConfigurerAdapter.class, OpenSessionInViewInterceptor.class})
    @ConditionalOnMissingBean(value={OpenSessionInViewInterceptor.class})
    @ConditionalOnProperty(prefix="spring.data.neo4j", name={"open-in-view"}, havingValue="true", matchIfMissing=true)
    protected static class Neo4jWebConfiguration {
        protected Neo4jWebConfiguration() {
        }

        @org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration
        protected static class Neo4jWebMvcConfiguration
        extends WebMvcConfigurerAdapter {
            protected Neo4jWebMvcConfiguration() {
            }

            @Bean
            public OpenSessionInViewInterceptor neo4jOpenSessionInViewInterceptor() {
                return new OpenSessionInViewInterceptor();
            }

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addWebRequestInterceptor((WebRequestInterceptor)this.neo4jOpenSessionInViewInterceptor());
            }
        }
    }
}

