/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.freemarker;

import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.qubership.profiler.shaded.org.springframework.boot.bind.RelaxedPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.core.io.ResourceLoader;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

public class FreeMarkerTemplateAvailabilityProvider
implements TemplateAvailabilityProvider {
    @Override
    public boolean isTemplateAvailable(String view, Environment environment, ClassLoader classLoader, ResourceLoader resourceLoader) {
        if (ClassUtils.isPresent("freemarker.template.Configuration", classLoader)) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(environment, "spring.freemarker.");
            String loaderPath = resolver.getProperty("template-loader-path", "classpath:/templates/");
            String prefix = resolver.getProperty("prefix", "");
            String suffix = resolver.getProperty("suffix", ".ftl");
            return resourceLoader.getResource(loaderPath + prefix + view + suffix).exists();
        }
        return false;
    }
}

