/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.groovy.template;

import groovy.text.markup.MarkupTemplateEngine;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.ConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.i18n.LocaleContextHolder;
import org.qubership.profiler.shaded.org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.view.groovy.GroovyMarkupConfig;
import org.qubership.profiler.shaded.org.springframework.web.servlet.view.groovy.GroovyMarkupConfigurer;
import org.qubership.profiler.shaded.org.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver;

@Configuration
@ConditionalOnClass(value={MarkupTemplateEngine.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={GroovyTemplateProperties.class})
public class GroovyTemplateAutoConfiguration {
    private static final Log logger = LogFactory.getLog(GroovyTemplateAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={Servlet.class, LocaleContextHolder.class, UrlBasedViewResolver.class})
    @ConditionalOnWebApplication
    @ConditionalOnProperty(name={"spring.groovy.template.enabled"}, matchIfMissing=true)
    public static class GroovyWebConfiguration {
        private final GroovyTemplateProperties properties;

        public GroovyWebConfiguration(GroovyTemplateProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean(name={"groovyMarkupViewResolver"})
        public GroovyMarkupViewResolver groovyMarkupViewResolver() {
            GroovyMarkupViewResolver resolver = new GroovyMarkupViewResolver();
            this.properties.applyToViewResolver(resolver);
            return resolver;
        }
    }

    @Configuration
    @ConditionalOnClass(value={GroovyMarkupConfigurer.class})
    public static class GroovyMarkupConfiguration {
        private final ApplicationContext applicationContext;
        private final GroovyTemplateProperties properties;
        private final MarkupTemplateEngine templateEngine;

        public GroovyMarkupConfiguration(ApplicationContext applicationContext, GroovyTemplateProperties properties, ObjectProvider<MarkupTemplateEngine> templateEngine) {
            this.applicationContext = applicationContext;
            this.properties = properties;
            this.templateEngine = templateEngine.getIfAvailable();
        }

        @PostConstruct
        public void checkTemplateLocationExists() {
            TemplateLocation location;
            if (this.properties.isCheckTemplateLocation() && !this.isUsingGroovyAllJar() && !(location = new TemplateLocation(this.properties.getResourceLoaderPath())).exists(this.applicationContext)) {
                logger.warn("Cannot find template location: " + location + " (please add some templates, check your Groovy configuration, or set spring.groovy.template.check-template-location=false)");
            }
        }

        private boolean isUsingGroovyAllJar() {
            try {
                ProtectionDomain domain = MarkupTemplateEngine.class.getProtectionDomain();
                CodeSource codeSource = domain.getCodeSource();
                return codeSource != null && codeSource.getLocation().toString().contains("-all");
            }
            catch (Exception ex) {
                return false;
            }
        }

        @Bean
        @ConditionalOnMissingBean(value={GroovyMarkupConfig.class})
        @ConfigurationProperties(prefix="spring.groovy.template.configuration")
        public GroovyMarkupConfigurer groovyMarkupConfigurer() {
            GroovyMarkupConfigurer configurer = new GroovyMarkupConfigurer();
            configurer.setResourceLoaderPath(this.properties.getResourceLoaderPath());
            configurer.setCacheTemplates(this.properties.isCache());
            if (this.templateEngine != null) {
                configurer.setTemplateEngine(this.templateEngine);
            }
            return configurer;
        }
    }
}

