/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hateoas;

import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.qubership.profiler.shaded.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanPostProcessor;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.data.rest.RepositoryRestMvcAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hateoas.HateoasProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hateoas.HypermediaHttpMessageConverterConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.HttpMessageConvertersAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.hateoas.EntityLinks;
import org.qubership.profiler.shaded.org.springframework.hateoas.LinkDiscoverers;
import org.qubership.profiler.shaded.org.springframework.hateoas.Resource;
import org.qubership.profiler.shaded.org.springframework.hateoas.config.EnableEntityLinks;
import org.qubership.profiler.shaded.org.springframework.hateoas.config.EnableHypermediaSupport;
import org.qubership.profiler.shaded.org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.qubership.profiler.shaded.org.springframework.plugin.core.Plugin;
import org.qubership.profiler.shaded.org.springframework.web.bind.annotation.RequestMapping;

@Configuration
@ConditionalOnClass(value={Resource.class, RequestMapping.class, Plugin.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, JacksonAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, RepositoryRestMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={HateoasProperties.class})
@Import(value={HypermediaHttpMessageConverterConfiguration.class})
public class HypermediaAutoConfiguration {

    private static class HalObjectMapperConfigurer
    implements BeanPostProcessor,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        private HalObjectMapperConfigurer() {
        }

        @Override
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof ObjectMapper && "_halObjectMapper".equals(beanName)) {
                this.postProcessHalObjectMapper((ObjectMapper)bean);
            }
            return bean;
        }

        private void postProcessHalObjectMapper(ObjectMapper objectMapper) {
            try {
                Jackson2ObjectMapperBuilder builder = this.beanFactory.getBean(Jackson2ObjectMapperBuilder.class);
                builder.configure(objectMapper);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }

        @Override
        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        @Override
        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={EntityLinks.class})
    @EnableEntityLinks
    protected static class EntityLinksConfiguration {
        protected EntityLinksConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={LinkDiscoverers.class})
    @ConditionalOnClass(value={ObjectMapper.class})
    @EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
    protected static class HypermediaConfiguration {
        protected HypermediaConfiguration() {
        }

        @Bean
        public static HalObjectMapperConfigurer halObjectMapperConfigurer() {
            return new HalObjectMapperConfigurer();
        }
    }
}

