/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.qubership.profiler.shaded.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.qubership.profiler.shaded.org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.qubership.profiler.shaded.org.springframework.jmx.export.MBeanExporter;
import org.qubership.profiler.shaded.org.springframework.jmx.support.JmxUtils;

@Configuration
@AutoConfigureBefore(value={XADataSourceAutoConfiguration.class, DataSourceAutoConfiguration.class})
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@ConditionalOnProperty(prefix="spring.datasource", name={"jndi-name"})
@EnableConfigurationProperties(value={DataSourceProperties.class})
public class JndiDataSourceAutoConfiguration {
    private final ApplicationContext context;

    public JndiDataSourceAutoConfiguration(ApplicationContext context) {
        this.context = context;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean
    public DataSource dataSource(DataSourceProperties properties) {
        JndiDataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
        DataSource dataSource = dataSourceLookup.getDataSource(properties.getJndiName());
        this.excludeMBeanIfNecessary(dataSource, "dataSource");
        return dataSource;
    }

    private void excludeMBeanIfNecessary(Object candidate, String beanName) {
        try {
            MBeanExporter mbeanExporter = this.context.getBean(MBeanExporter.class);
            if (JmxUtils.isMBean(candidate.getClass())) {
                mbeanExporter.addExcludedBean(beanName);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }
}

