/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jooq;

import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.RecordListenerProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.TransactionProvider;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jooq.JooqExceptionTranslator;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jooq.JooqProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jooq.SpringTransactionProvider;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.qubership.profiler.shaded.org.springframework.transaction.PlatformTransactionManager;

@org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration
@ConditionalOnClass(value={DSLContext.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class JooqAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DataSourceConnectionProvider.class})
    public DataSourceConnectionProvider dataSourceConnectionProvider(DataSource dataSource) {
        return new DataSourceConnectionProvider((DataSource)new TransactionAwareDataSourceProxy(dataSource));
    }

    @Bean
    @ConditionalOnBean(value={PlatformTransactionManager.class})
    public SpringTransactionProvider transactionProvider(PlatformTransactionManager txManager) {
        return new SpringTransactionProvider(txManager);
    }

    @Bean
    public DefaultExecuteListenerProvider jooqExceptionTranslatorExecuteListenerProvider() {
        return new DefaultExecuteListenerProvider((ExecuteListener)new JooqExceptionTranslator());
    }

    @org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration
    @ConditionalOnMissingBean(value={DSLContext.class})
    @EnableConfigurationProperties(value={JooqProperties.class})
    public static class DslContextConfiguration {
        private final JooqProperties properties;
        private final ConnectionProvider connection;
        private final TransactionProvider transactionProvider;
        private final RecordMapperProvider recordMapperProvider;
        private final Settings settings;
        private final RecordListenerProvider[] recordListenerProviders;
        private final ExecuteListenerProvider[] executeListenerProviders;
        private final VisitListenerProvider[] visitListenerProviders;

        public DslContextConfiguration(JooqProperties properties, ConnectionProvider connectionProvider, ObjectProvider<TransactionProvider> transactionProvider, ObjectProvider<RecordMapperProvider> recordMapperProvider, ObjectProvider<Settings> settings, ObjectProvider<RecordListenerProvider[]> recordListenerProviders, ExecuteListenerProvider[] executeListenerProviders, ObjectProvider<VisitListenerProvider[]> visitListenerProviders) {
            this.properties = properties;
            this.connection = connectionProvider;
            this.transactionProvider = transactionProvider.getIfAvailable();
            this.recordMapperProvider = recordMapperProvider.getIfAvailable();
            this.settings = settings.getIfAvailable();
            this.recordListenerProviders = recordListenerProviders.getIfAvailable();
            this.executeListenerProviders = executeListenerProviders;
            this.visitListenerProviders = visitListenerProviders.getIfAvailable();
        }

        @Bean
        public DefaultDSLContext dslContext(Configuration configuration) {
            return new DefaultDSLContext(configuration);
        }

        @Bean
        @ConditionalOnMissingBean(value={Configuration.class})
        public DefaultConfiguration jooqConfiguration() {
            DefaultConfiguration configuration = new DefaultConfiguration();
            if (this.properties.getSqlDialect() != null) {
                configuration.set(this.properties.getSqlDialect());
            }
            configuration.set(this.connection);
            if (this.transactionProvider != null) {
                configuration.set(this.transactionProvider);
            }
            if (this.recordMapperProvider != null) {
                configuration.set(this.recordMapperProvider);
            }
            if (this.settings != null) {
                configuration.set(this.settings);
            }
            configuration.set(this.recordListenerProviders);
            configuration.set(this.executeListenerProviders);
            configuration.set(this.visitListenerProviders);
            return configuration;
        }
    }
}

