/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.ldap;

import java.util.Collections;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.ldap.LdapProperties;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.ldap.core.ContextSource;
import org.qubership.profiler.shaded.org.springframework.ldap.core.support.LdapContextSource;

@Configuration
@ConditionalOnClass(value={ContextSource.class})
@EnableConfigurationProperties(value={LdapProperties.class})
public class LdapAutoConfiguration {
    private final LdapProperties properties;
    private final Environment environment;

    public LdapAutoConfiguration(LdapProperties properties, Environment environment) {
        this.properties = properties;
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean
    public ContextSource ldapContextSource() {
        LdapContextSource source = new LdapContextSource();
        source.setUserDn(this.properties.getUsername());
        source.setPassword(this.properties.getPassword());
        source.setBase(this.properties.getBase());
        source.setUrls(this.properties.determineUrls(this.environment));
        source.setBaseEnvironmentProperties(Collections.unmodifiableMap(this.properties.getBaseEnvironment()));
        return source;
    }
}

