/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.client;

import java.util.Collections;
import javax.servlet.Filter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2SsoProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateFactory;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationEventPublisher;
import org.qubership.profiler.shaded.org.springframework.http.HttpStatus;
import org.qubership.profiler.shaded.org.springframework.http.MediaType;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.qubership.profiler.shaded.org.springframework.security.web.AuthenticationEntryPoint;
import org.qubership.profiler.shaded.org.springframework.security.web.DefaultSecurityFilterChain;
import org.qubership.profiler.shaded.org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.qubership.profiler.shaded.org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.qubership.profiler.shaded.org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.qubership.profiler.shaded.org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.qubership.profiler.shaded.org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.qubership.profiler.shaded.org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.qubership.profiler.shaded.org.springframework.security.web.util.matcher.RequestMatcher;
import org.qubership.profiler.shaded.org.springframework.web.accept.ContentNegotiationStrategy;
import org.qubership.profiler.shaded.org.springframework.web.accept.HeaderContentNegotiationStrategy;

class SsoSecurityConfigurer {
    private ApplicationContext applicationContext;

    SsoSecurityConfigurer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void configure(HttpSecurity http) throws Exception {
        OAuth2SsoProperties sso = this.applicationContext.getBean(OAuth2SsoProperties.class);
        http.apply((SecurityConfigurerAdapter)new OAuth2ClientAuthenticationConfigurer(this.oauth2SsoFilter(sso)));
        this.addAuthenticationEntryPoint(http, sso);
    }

    private void addAuthenticationEntryPoint(HttpSecurity http, OAuth2SsoProperties sso) throws Exception {
        ExceptionHandlingConfigurer exceptions = http.exceptionHandling();
        ContentNegotiationStrategy contentNegotiationStrategy = (ContentNegotiationStrategy)http.getSharedObject(ContentNegotiationStrategy.class);
        if (contentNegotiationStrategy == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        MediaTypeRequestMatcher preferredMatcher = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.APPLICATION_XHTML_XML, new MediaType("image", "*"), MediaType.TEXT_HTML, MediaType.TEXT_PLAIN});
        preferredMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        exceptions.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(sso.getLoginPath()), (RequestMatcher)preferredMatcher);
        exceptions.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
    }

    private OAuth2ClientAuthenticationProcessingFilter oauth2SsoFilter(OAuth2SsoProperties sso) {
        OAuth2RestTemplate restTemplate = this.applicationContext.getBean(UserInfoRestTemplateFactory.class).getUserInfoRestTemplate();
        ResourceServerTokenServices tokenServices = this.applicationContext.getBean(ResourceServerTokenServices.class);
        OAuth2ClientAuthenticationProcessingFilter filter = new OAuth2ClientAuthenticationProcessingFilter(sso.getLoginPath());
        filter.setRestTemplate((OAuth2RestOperations)restTemplate);
        filter.setTokenServices(tokenServices);
        filter.setApplicationEventPublisher((ApplicationEventPublisher)this.applicationContext);
        return filter;
    }

    private static class OAuth2ClientAuthenticationConfigurer
    extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
        private OAuth2ClientAuthenticationProcessingFilter filter;

        OAuth2ClientAuthenticationConfigurer(OAuth2ClientAuthenticationProcessingFilter filter) {
            this.filter = filter;
        }

        public void configure(HttpSecurity builder) throws Exception {
            OAuth2ClientAuthenticationProcessingFilter ssoFilter = this.filter;
            ssoFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)builder.getSharedObject(SessionAuthenticationStrategy.class));
            builder.addFilterAfter((Filter)ssoFilter, AbstractPreAuthenticatedProcessingFilter.class);
        }
    }
}

