/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.resource;

import org.qubership.profiler.shaded.org.springframework.beans.BeanUtils;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanPostProcessor;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerTokenServicesConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.bind.RelaxedPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Condition;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConditionContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConfigurationCondition;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.core.annotation.AnnotationUtils;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotatedTypeMetadata;
import org.qubership.profiler.shaded.org.springframework.core.type.StandardAnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfiguration;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurer;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

@Configuration
@Conditional(value={ResourceServerCondition.class})
@ConditionalOnClass(value={EnableResourceServer.class, SecurityProperties.class})
@ConditionalOnWebApplication
@ConditionalOnBean(value={ResourceServerConfiguration.class})
@Import(value={ResourceServerTokenServicesConfiguration.class})
public class OAuth2ResourceServerConfiguration {
    private final ResourceServerProperties resource;

    public OAuth2ResourceServerConfiguration(ResourceServerProperties resource) {
        this.resource = resource;
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceServerConfigurer.class})
    public ResourceServerConfigurer resourceServer() {
        return new ResourceSecurityConfigurer(this.resource);
    }

    @Bean
    public static ResourceServerFilterChainOrderProcessor resourceServerFilterChainOrderProcessor(ResourceServerProperties properties) {
        return new ResourceServerFilterChainOrderProcessor(properties);
    }

    @ConditionalOnBean(value={AuthorizationServerEndpointsConfiguration.class})
    private static class AuthorizationServerEndpointsConfigurationBeanCondition {
        private AuthorizationServerEndpointsConfigurationBeanCondition() {
        }

        public static boolean matches(ConditionContext context) {
            Class<AuthorizationServerEndpointsConfigurationBeanCondition> type = AuthorizationServerEndpointsConfigurationBeanCondition.class;
            Conditional conditional = AnnotationUtils.findAnnotation(type, Conditional.class);
            StandardAnnotationMetadata metadata = new StandardAnnotationMetadata(type);
            for (Class<? extends Condition> conditionType : conditional.value()) {
                Condition condition = BeanUtils.instantiateClass(conditionType);
                if (!condition.matches(context, metadata)) continue;
                return true;
            }
            return false;
        }
    }

    protected static class ResourceServerCondition
    extends SpringBootCondition
    implements ConfigurationCondition {
        private static final String AUTHORIZATION_ANNOTATION = "org.qubership.profiler.shaded.org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration";

        protected ResourceServerCondition() {
        }

        @Override
        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition("OAuth ResourceServer Condition", new Object[0]);
            Environment environment = context.getEnvironment();
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(environment, "security.oauth2.resource.");
            if (this.hasOAuthClientId(environment)) {
                return ConditionOutcome.match(message.foundExactly("client-id property"));
            }
            if (!resolver.getSubProperties("jwt").isEmpty()) {
                return ConditionOutcome.match(message.foundExactly("JWT resource configuration"));
            }
            if (StringUtils.hasText(resolver.getProperty("user-info-uri"))) {
                return ConditionOutcome.match(message.foundExactly("user-info-uri property"));
            }
            if (ClassUtils.isPresent(AUTHORIZATION_ANNOTATION, null) && AuthorizationServerEndpointsConfigurationBeanCondition.matches(context)) {
                return ConditionOutcome.match(message.found("class").items(AUTHORIZATION_ANNOTATION));
            }
            return ConditionOutcome.noMatch(message.didNotFind("client id, JWT resource or authorization server").atAll());
        }

        private boolean hasOAuthClientId(Environment environment) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(environment, "security.oauth2.client.");
            return StringUtils.hasLength(resolver.getProperty("client-id", ""));
        }
    }

    private static final class ResourceServerFilterChainOrderProcessor
    implements BeanPostProcessor {
        private final ResourceServerProperties properties;

        private ResourceServerFilterChainOrderProcessor(ResourceServerProperties properties) {
            this.properties = properties;
        }

        @Override
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        @Override
        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof ResourceServerConfiguration) {
                ResourceServerConfiguration config = (ResourceServerConfiguration)bean;
                config.setOrder(this.properties.getFilterOrder());
            }
            return bean;
        }
    }

    protected static class ResourceSecurityConfigurer
    extends ResourceServerConfigurerAdapter {
        private ResourceServerProperties resource;

        public ResourceSecurityConfigurer(ResourceServerProperties resource) {
            this.resource = resource;
        }

        public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
            resources.resourceId(this.resource.getResourceId());
        }

        public void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        }
    }
}

