/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.thymeleaf;

import java.util.LinkedHashMap;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.util.MimeType;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.view.ThymeleafViewResolver;

abstract class AbstractThymeleafViewResolverConfiguration {
    private final ThymeleafProperties properties;
    private final SpringTemplateEngine templateEngine;

    protected AbstractThymeleafViewResolverConfiguration(ThymeleafProperties properties, SpringTemplateEngine templateEngine) {
        this.properties = properties;
        this.templateEngine = templateEngine;
    }

    @Bean
    @ConditionalOnMissingBean(name={"thymeleafViewResolver"})
    @ConditionalOnProperty(name={"spring.thymeleaf.enabled"}, matchIfMissing=true)
    public ThymeleafViewResolver thymeleafViewResolver() {
        ThymeleafViewResolver resolver = new ThymeleafViewResolver();
        this.configureTemplateEngine(resolver, this.templateEngine);
        resolver.setCharacterEncoding(this.properties.getEncoding().name());
        resolver.setContentType(this.appendCharset(this.properties.getContentType(), resolver.getCharacterEncoding()));
        resolver.setExcludedViewNames(this.properties.getExcludedViewNames());
        resolver.setViewNames(this.properties.getViewNames());
        resolver.setOrder(0x7FFFFFFA);
        resolver.setCache(this.properties.isCache());
        return resolver;
    }

    protected abstract void configureTemplateEngine(ThymeleafViewResolver var1, SpringTemplateEngine var2);

    private String appendCharset(MimeType type, String charset) {
        if (type.getCharset() != null) {
            return type.toString();
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("charset", charset);
        parameters.putAll(type.getParameters());
        return new MimeType(type, parameters).toString();
    }
}

