/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.qubership.profiler.shaded.org.springframework.http.converter.FormHttpMessageConverter;
import org.qubership.profiler.shaded.org.springframework.http.converter.HttpMessageConverter;
import org.qubership.profiler.shaded.org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.qubership.profiler.shaded.org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.qubership.profiler.shaded.org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;
import org.qubership.profiler.shaded.org.springframework.web.client.RestTemplate;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

public class HttpMessageConverters
implements Iterable<HttpMessageConverter<?>> {
    private static final List<Class<?>> NON_REPLACING_CONVERTERS;
    private final List<HttpMessageConverter<?>> converters;

    public HttpMessageConverters(HttpMessageConverter<?> ... additionalConverters) {
        this(Arrays.asList(additionalConverters));
    }

    public HttpMessageConverters(Collection<HttpMessageConverter<?>> additionalConverters) {
        this(true, additionalConverters);
    }

    public HttpMessageConverters(boolean addDefaultConverters, Collection<HttpMessageConverter<?>> converters) {
        List<HttpMessageConverter<?>> combined = this.getCombinedConverters(converters, addDefaultConverters ? this.getDefaultConverters() : Collections.emptyList());
        combined = this.postProcessConverters(combined);
        this.converters = Collections.unmodifiableList(combined);
    }

    private List<HttpMessageConverter<?>> getCombinedConverters(Collection<HttpMessageConverter<?>> converters, List<HttpMessageConverter<?>> defaultConverters) {
        ArrayList combined = new ArrayList();
        ArrayList processing = new ArrayList(converters);
        for (HttpMessageConverter<?> defaultConverter : defaultConverters) {
            Iterator iterator = processing.iterator();
            while (iterator.hasNext()) {
                HttpMessageConverter candidate = (HttpMessageConverter)iterator.next();
                if (!this.isReplacement(defaultConverter, candidate)) continue;
                combined.add(candidate);
                iterator.remove();
            }
            combined.add(defaultConverter);
            if (!(defaultConverter instanceof AllEncompassingFormHttpMessageConverter)) continue;
            this.configurePartConverters((AllEncompassingFormHttpMessageConverter)defaultConverter, converters);
        }
        combined.addAll(0, processing);
        return combined;
    }

    private boolean isReplacement(HttpMessageConverter<?> defaultConverter, HttpMessageConverter<?> candidate) {
        for (Class<?> nonReplacingConverter : NON_REPLACING_CONVERTERS) {
            if (!nonReplacingConverter.isInstance(candidate)) continue;
            return false;
        }
        return ClassUtils.isAssignableValue(defaultConverter.getClass(), candidate);
    }

    private void configurePartConverters(AllEncompassingFormHttpMessageConverter formConverter, Collection<HttpMessageConverter<?>> converters) {
        List<HttpMessageConverter<?>> partConverters = this.extractPartConverters((FormHttpMessageConverter)formConverter);
        List<HttpMessageConverter<?>> combinedConverters = this.getCombinedConverters(converters, partConverters);
        combinedConverters = this.postProcessPartConverters(combinedConverters);
        formConverter.setPartConverters(combinedConverters);
    }

    private List<HttpMessageConverter<?>> extractPartConverters(FormHttpMessageConverter formConverter) {
        Field field = ReflectionUtils.findField(FormHttpMessageConverter.class, "partConverters");
        ReflectionUtils.makeAccessible(field);
        return (List)ReflectionUtils.getField(field, formConverter);
    }

    protected List<HttpMessageConverter<?>> postProcessConverters(List<HttpMessageConverter<?>> converters) {
        return converters;
    }

    protected List<HttpMessageConverter<?>> postProcessPartConverters(List<HttpMessageConverter<?>> converters) {
        return converters;
    }

    private List<HttpMessageConverter<?>> getDefaultConverters() {
        ArrayList converters = new ArrayList();
        if (ClassUtils.isPresent("org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport", null)) {
            converters.addAll(new WebMvcConfigurationSupport(){

                public List<HttpMessageConverter<?>> defaultMessageConverters() {
                    return super.getMessageConverters();
                }
            }.defaultMessageConverters());
        } else {
            converters.addAll(new RestTemplate().getMessageConverters());
        }
        this.reorderXmlConvertersToEnd(converters);
        return converters;
    }

    private void reorderXmlConvertersToEnd(List<HttpMessageConverter<?>> converters) {
        ArrayList xml = new ArrayList();
        Iterator<HttpMessageConverter<?>> iterator = converters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter<?> converter = iterator.next();
            if (!(converter instanceof AbstractXmlHttpMessageConverter) && !(converter instanceof MappingJackson2XmlHttpMessageConverter)) continue;
            xml.add(converter);
            iterator.remove();
        }
        converters.addAll(xml);
    }

    @Override
    public Iterator<HttpMessageConverter<?>> iterator() {
        return this.getConverters().iterator();
    }

    public List<HttpMessageConverter<?>> getConverters() {
        return this.converters;
    }

    private static void addClassIfExists(List<Class<?>> list, String className) {
        try {
            list.add(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    static {
        ArrayList nonReplacingConverters = new ArrayList();
        HttpMessageConverters.addClassIfExists(nonReplacingConverters, "org.qubership.profiler.shaded.org.springframework.hateoas.mvc.TypeConstrainedMappingJackson2HttpMessageConverter");
        NON_REPLACING_CONVERTERS = Collections.unmodifiableList(nonReplacingConverters);
    }
}

