/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.websocket;

import java.lang.reflect.Constructor;
import org.qubership.profiler.shaded.org.apache.catalina.Context;
import org.qubership.profiler.shaded.org.springframework.beans.BeanUtils;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.websocket.WebSocketContainerCustomizer;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;

public class TomcatWebSocketContainerCustomizer
extends WebSocketContainerCustomizer<TomcatEmbeddedServletContainerFactory> {
    private static final String TOMCAT_7_LISTENER_TYPE = "org.qubership.profiler.shaded.org.apache.catalina.deploy.ApplicationListener";
    private static final String TOMCAT_8_LISTENER_TYPE = "org.qubership.profiler.shaded.org.apache.tomcat.util.descriptor.web.ApplicationListener";
    private static final String WS_LISTENER = "org.qubership.profiler.shaded.org.apache.tomcat.websocket.server.WsContextListener";

    @Override
    public void doCustomize(TomcatEmbeddedServletContainerFactory tomcatContainer) {
        tomcatContainer.addContextCustomizers(new TomcatContextCustomizer(){

            @Override
            public void customize(Context context) {
                TomcatWebSocketContainerCustomizer.this.addListener(context, TomcatWebSocketContainerCustomizer.this.findListenerType());
            }
        });
    }

    private Class<?> findListenerType() {
        if (ClassUtils.isPresent(TOMCAT_7_LISTENER_TYPE, null)) {
            return ClassUtils.resolveClassName(TOMCAT_7_LISTENER_TYPE, null);
        }
        if (ClassUtils.isPresent(TOMCAT_8_LISTENER_TYPE, null)) {
            return ClassUtils.resolveClassName(TOMCAT_8_LISTENER_TYPE, null);
        }
        return null;
    }

    private void addListener(Context context, Class<?> listenerType) {
        Class<?> contextClass = context.getClass();
        if (listenerType == null) {
            ReflectionUtils.invokeMethod(ClassUtils.getMethod(contextClass, "addApplicationListener", String.class), context, WS_LISTENER);
        } else {
            Constructor<?> constructor = ClassUtils.getConstructorIfAvailable(listenerType, String.class, Boolean.TYPE);
            Object instance = BeanUtils.instantiateClass(constructor, WS_LISTENER, false);
            ReflectionUtils.invokeMethod(ClassUtils.getMethod(contextClass, "addApplicationListener", listenerType), context, instance);
        }
    }
}

