/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.qubership.profiler.shaded.org.springframework.beans.BeanUtils;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContextException;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContextInitializer;
import org.qubership.profiler.shaded.org.springframework.context.ConfigurableApplicationContext;
import org.qubership.profiler.shaded.org.springframework.core.GenericTypeResolver;
import org.qubership.profiler.shaded.org.springframework.core.Ordered;
import org.qubership.profiler.shaded.org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.qubership.profiler.shaded.org.springframework.core.env.ConfigurableEnvironment;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class DelegatingApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final String PROPERTY_NAME = "context.initializer.classes";
    private int order = 0;

    @Override
    public void initialize(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        List<Class<?>> initializerClasses = this.getInitializerClasses(environment);
        if (!initializerClasses.isEmpty()) {
            this.applyInitializerClasses(context, initializerClasses);
        }
    }

    private List<Class<?>> getInitializerClasses(ConfigurableEnvironment env) {
        String classNames = env.getProperty(PROPERTY_NAME);
        ArrayList classes = new ArrayList();
        if (StringUtils.hasLength(classNames)) {
            for (String className : StringUtils.tokenizeToStringArray(classNames, ",")) {
                classes.add(this.getInitializerClass(className));
            }
        }
        return classes;
    }

    private Class<?> getInitializerClass(String className) throws LinkageError {
        try {
            Class<?> initializerClass = ClassUtils.forName(className, ClassUtils.getDefaultClassLoader());
            Assert.isAssignable(ApplicationContextInitializer.class, initializerClass);
            return initializerClass;
        }
        catch (ClassNotFoundException ex) {
            throw new ApplicationContextException("Failed to load context initializer class [" + className + "]", ex);
        }
    }

    private void applyInitializerClasses(ConfigurableApplicationContext context, List<Class<?>> initializerClasses) {
        Class<?> contextClass = context.getClass();
        ArrayList initializers = new ArrayList();
        for (Class<?> initializerClass : initializerClasses) {
            initializers.add(this.instantiateInitializer(contextClass, initializerClass));
        }
        this.applyInitializers(context, initializers);
    }

    private ApplicationContextInitializer<?> instantiateInitializer(Class<?> contextClass, Class<?> initializerClass) {
        Class<?> requireContextClass = GenericTypeResolver.resolveTypeArgument(initializerClass, ApplicationContextInitializer.class);
        Assert.isAssignable(requireContextClass, contextClass, String.format("Could not add context initializer [%s] as its generic parameter [%s] is not assignable from the type of application context used by this context loader [%s]: ", initializerClass.getName(), requireContextClass.getName(), contextClass.getName()));
        return (ApplicationContextInitializer)BeanUtils.instantiateClass(initializerClass);
    }

    private void applyInitializers(ConfigurableApplicationContext context, List<ApplicationContextInitializer<?>> initializers) {
        Collections.sort(initializers, new AnnotationAwareOrderComparator());
        for (ApplicationContextInitializer<?> initializer : initializers) {
            initializer.initialize(context);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }
}

