/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.context.embedded.tomcat;

import org.qubership.profiler.shaded.org.apache.catalina.Container;
import org.qubership.profiler.shaded.org.apache.catalina.Manager;
import org.qubership.profiler.shaded.org.apache.catalina.SessionIdGenerator;
import org.qubership.profiler.shaded.org.apache.catalina.core.StandardContext;
import org.qubership.profiler.shaded.org.apache.catalina.session.ManagerBase;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.tomcat.LazySessionIdGenerator;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.tomcat.TomcatStarter;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;

class TomcatEmbeddedContext
extends StandardContext {
    private TomcatStarter starter;
    private final boolean overrideLoadOnStart = ReflectionUtils.findMethod(StandardContext.class, "loadOnStartup", Container[].class).getReturnType() == Boolean.TYPE;

    TomcatEmbeddedContext() {
    }

    public boolean loadOnStartup(Container[] children) {
        if (this.overrideLoadOnStart) {
            return true;
        }
        return super.loadOnStartup(children);
    }

    public void setManager(Manager manager) {
        if (manager instanceof ManagerBase) {
            ((ManagerBase)manager).setSessionIdGenerator((SessionIdGenerator)new LazySessionIdGenerator());
        }
        super.setManager(manager);
    }

    public void deferredLoadOnStartup() {
        ClassLoader classLoader = this.getLoader().getClassLoader();
        ClassLoader existingLoader = null;
        if (classLoader != null) {
            existingLoader = ClassUtils.overrideThreadContextClassLoader(classLoader);
        }
        if (this.overrideLoadOnStart) {
            super.loadOnStartup(this.findChildren());
        }
        if (existingLoader != null) {
            ClassUtils.overrideThreadContextClassLoader(existingLoader);
        }
    }

    public void setStarter(TomcatStarter starter) {
        this.starter = starter;
    }

    public TomcatStarter getStarter() {
        return this.starter;
    }
}

