/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.jackson;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.qubership.profiler.shaded.com.fasterxml.jackson.core.JsonParser;
import org.qubership.profiler.shaded.com.fasterxml.jackson.core.ObjectCodec;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.node.NullNode;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public abstract class JsonObjectDeserializer<T>
extends JsonDeserializer<T> {
    @Override
    public final T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        try {
            ObjectCodec codec = jp.getCodec();
            JsonNode tree = (JsonNode)codec.readTree(jp);
            return this.deserializeObject(jp, ctxt, codec, tree);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new JsonMappingException((Closeable)jp, "Object deserialize error", (Throwable)ex);
        }
    }

    protected abstract T deserializeObject(JsonParser var1, DeserializationContext var2, ObjectCodec var3, JsonNode var4) throws IOException;

    protected final <D> D nullSafeValue(JsonNode jsonNode, Class<D> type) {
        Assert.notNull(type, "Type must not be null");
        if (jsonNode == null) {
            return null;
        }
        if (type == String.class) {
            return (D)jsonNode.textValue();
        }
        if (type == Boolean.class) {
            return (D)Boolean.valueOf(jsonNode.booleanValue());
        }
        if (type == Long.class) {
            return (D)Long.valueOf(jsonNode.longValue());
        }
        if (type == Integer.class) {
            return (D)Integer.valueOf(jsonNode.intValue());
        }
        if (type == Short.class) {
            return (D)Short.valueOf(jsonNode.shortValue());
        }
        if (type == Double.class) {
            return (D)Double.valueOf(jsonNode.doubleValue());
        }
        if (type == Float.class) {
            return (D)Float.valueOf(jsonNode.floatValue());
        }
        if (type == BigDecimal.class) {
            return (D)jsonNode.decimalValue();
        }
        if (type == BigInteger.class) {
            return (D)jsonNode.bigIntegerValue();
        }
        throw new IllegalArgumentException("Unsupported value type " + type.getName());
    }

    protected final JsonNode getRequiredNode(JsonNode tree, String fieldName) {
        Assert.notNull(tree, "Tree must not be null");
        JsonNode node = tree.get(fieldName);
        Assert.state(node != null && !(node instanceof NullNode), "Missing JSON field '" + fieldName + "'");
        return node;
    }
}

