/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.json;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.shaded.org.springframework.boot.json.JsonParser;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class BasicJsonParser
implements JsonParser {
    @Override
    public Map<String, Object> parseMap(String json) {
        if (json != null && (json = json.trim()).startsWith("{")) {
            return this.parseMapInternal(json);
        }
        throw new IllegalArgumentException("Cannot parse JSON");
    }

    @Override
    public List<Object> parseList(String json) {
        if (json != null && (json = json.trim()).startsWith("[")) {
            return this.parseListInternal(json);
        }
        throw new IllegalArgumentException("Cannot parse JSON");
    }

    private List<Object> parseListInternal(String json) {
        ArrayList<Object> list = new ArrayList<Object>();
        json = BasicJsonParser.trimLeadingCharacter(BasicJsonParser.trimTrailingCharacter(json, ']'), '[');
        for (String value : this.tokenize(json)) {
            list.add(this.parseInternal(value));
        }
        return list;
    }

    private Object parseInternal(String json) {
        if (json.startsWith("[")) {
            return this.parseListInternal(json);
        }
        if (json.startsWith("{")) {
            return this.parseMapInternal(json);
        }
        if (json.startsWith("\"")) {
            return BasicJsonParser.trimTrailingCharacter(BasicJsonParser.trimLeadingCharacter(json, '\"'), '\"');
        }
        try {
            return Long.valueOf(json);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(json);
            }
            catch (NumberFormatException numberFormatException2) {
                return json;
            }
        }
    }

    private static String trimTrailingCharacter(String string, char c) {
        if (string.length() > 0 && string.charAt(string.length() - 1) == c) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String trimLeadingCharacter(String string, char c) {
        if (string.length() > 0 && string.charAt(0) == c) {
            return string.substring(1);
        }
        return string;
    }

    private Map<String, Object> parseMapInternal(String json) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        json = BasicJsonParser.trimLeadingCharacter(BasicJsonParser.trimTrailingCharacter(json, '}'), '{');
        for (String pair : this.tokenize(json)) {
            String[] values = StringUtils.trimArrayElements(StringUtils.split(pair, ":"));
            String key = BasicJsonParser.trimLeadingCharacter(BasicJsonParser.trimTrailingCharacter(values[0], '\"'), '\"');
            Object value = null;
            if (values.length > 0) {
                String string = BasicJsonParser.trimLeadingCharacter(BasicJsonParser.trimTrailingCharacter(values[1], '\"'), '\"');
                value = this.parseInternal(string);
            }
            map.put(key, value);
        }
        return map;
    }

    private List<String> tokenize(String json) {
        ArrayList<String> list = new ArrayList<String>();
        int inObject = 0;
        int inList = 0;
        StringBuilder build = new StringBuilder();
        for (int index = 0; index < json.length(); ++index) {
            char current = json.charAt(index);
            if (current == '{') {
                ++inObject;
            }
            if (current == '}') {
                --inObject;
            }
            if (current == '[') {
                ++inList;
            }
            if (current == ']') {
                --inList;
            }
            if (current == ',' && inObject == 0 && inList == 0) {
                list.add(build.toString());
                build.setLength(0);
                continue;
            }
            build.append(current);
        }
        if (build.length() > 0) {
            list.add(build.toString());
        }
        return list;
    }
}

