/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.jta.narayana;

import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.qubership.profiler.shaded.org.springframework.boot.jta.XADataSourceWrapper;
import org.qubership.profiler.shaded.org.springframework.boot.jta.narayana.DataSourceXAResourceRecoveryHelper;
import org.qubership.profiler.shaded.org.springframework.boot.jta.narayana.NarayanaDataSourceBean;
import org.qubership.profiler.shaded.org.springframework.boot.jta.narayana.NarayanaProperties;
import org.qubership.profiler.shaded.org.springframework.boot.jta.narayana.NarayanaRecoveryManagerBean;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public class NarayanaXADataSourceWrapper
implements XADataSourceWrapper {
    private final NarayanaRecoveryManagerBean recoveryManager;
    private final NarayanaProperties properties;

    public NarayanaXADataSourceWrapper(NarayanaRecoveryManagerBean recoveryManager, NarayanaProperties properties) {
        Assert.notNull(recoveryManager, "RecoveryManager must not be null");
        Assert.notNull(properties, "Properties must not be null");
        this.recoveryManager = recoveryManager;
        this.properties = properties;
    }

    @Override
    public DataSource wrapDataSource(XADataSource dataSource) {
        XAResourceRecoveryHelper recoveryHelper = this.getRecoveryHelper(dataSource);
        this.recoveryManager.registerXAResourceRecoveryHelper(recoveryHelper);
        return new NarayanaDataSourceBean(dataSource);
    }

    private XAResourceRecoveryHelper getRecoveryHelper(XADataSource dataSource) {
        if (this.properties.getRecoveryDbUser() == null && this.properties.getRecoveryDbPass() == null) {
            return new DataSourceXAResourceRecoveryHelper(dataSource);
        }
        return new DataSourceXAResourceRecoveryHelper(dataSource, this.properties.getRecoveryDbUser(), this.properties.getRecoveryDbPass());
    }
}

