/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.logging.logback;

import org.qubership.profiler.shaded.ch.qos.logback.core.joran.action.Action;
import org.qubership.profiler.shaded.ch.qos.logback.core.joran.action.ActionUtil;
import org.qubership.profiler.shaded.ch.qos.logback.core.joran.spi.ActionException;
import org.qubership.profiler.shaded.ch.qos.logback.core.joran.spi.InterpretationContext;
import org.qubership.profiler.shaded.ch.qos.logback.core.util.OptionHelper;
import org.qubership.profiler.shaded.org.springframework.boot.bind.RelaxedPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.xml.sax.Attributes;

class SpringPropertyAction
extends Action {
    private static final String SOURCE_ATTRIBUTE = "source";
    private static final String DEFAULT_VALUE_ATTRIBUTE = "defaultValue";
    private final Environment environment;

    SpringPropertyAction(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void begin(InterpretationContext ic, String elementName, Attributes attributes) throws ActionException {
        String name = attributes.getValue("name");
        String source = attributes.getValue(SOURCE_ATTRIBUTE);
        ActionUtil.Scope scope = ActionUtil.stringToScope(attributes.getValue("scope"));
        String defaultValue = attributes.getValue(DEFAULT_VALUE_ATTRIBUTE);
        if (OptionHelper.isEmpty(name) || OptionHelper.isEmpty(source)) {
            this.addError("The \"name\" and \"source\" attributes of <springProperty> must be set");
        }
        ActionUtil.setProperty(ic, name, this.getValue(source, defaultValue), scope);
    }

    private String getValue(String source, String defaultValue) {
        if (this.environment == null) {
            this.addWarn("No Spring Environment available to resolve " + source);
            return defaultValue;
        }
        String value = this.environment.getProperty(source);
        if (value != null) {
            return value;
        }
        int lastDot = source.lastIndexOf(".");
        if (lastDot > 0) {
            String prefix = source.substring(0, lastDot + 1);
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(this.environment, prefix);
            return resolver.getProperty(source.substring(lastDot + 1), defaultValue);
        }
        return defaultValue;
    }

    @Override
    public void end(InterpretationContext ic, String name) throws ActionException {
    }
}

