/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.web.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanDefinition;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ServletComponentHandler;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.WebFilterHandler;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.WebListenerHandler;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.WebServletHandler;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContextAware;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.qubership.profiler.shaded.org.springframework.web.context.WebApplicationContext;

class ServletComponentRegisteringPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final List<ServletComponentHandler> HANDLERS;
    private final Set<String> packagesToScan;
    private ApplicationContext applicationContext;

    ServletComponentRegisteringPostProcessor(Set<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.isRunningInEmbeddedContainer()) {
            ClassPathScanningCandidateComponentProvider componentProvider = this.createComponentProvider();
            for (String packageToScan : this.packagesToScan) {
                this.scanPackage(componentProvider, packageToScan);
            }
        }
    }

    private void scanPackage(ClassPathScanningCandidateComponentProvider componentProvider, String packageToScan) {
        for (BeanDefinition candidate : componentProvider.findCandidateComponents(packageToScan)) {
            if (!(candidate instanceof ScannedGenericBeanDefinition)) continue;
            for (ServletComponentHandler handler : HANDLERS) {
                handler.handle((ScannedGenericBeanDefinition)candidate, (BeanDefinitionRegistry)((Object)this.applicationContext));
            }
        }
    }

    private boolean isRunningInEmbeddedContainer() {
        return this.applicationContext instanceof WebApplicationContext && ((WebApplicationContext)this.applicationContext).getServletContext() == null;
    }

    private ClassPathScanningCandidateComponentProvider createComponentProvider() {
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.setEnvironment(this.applicationContext.getEnvironment());
        componentProvider.setResourceLoader(this.applicationContext);
        for (ServletComponentHandler handler : HANDLERS) {
            componentProvider.addIncludeFilter(handler.getTypeFilter());
        }
        return componentProvider;
    }

    Set<String> getPackagesToScan() {
        return Collections.unmodifiableSet(this.packagesToScan);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    static {
        ArrayList<ServletComponentHandler> handlers = new ArrayList<ServletComponentHandler>();
        handlers.add(new WebServletHandler());
        handlers.add(new WebFilterHandler());
        handlers.add(new WebListenerHandler());
        HANDLERS = Collections.unmodifiableList(handlers);
    }
}

