/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qubership.profiler.shaded.org.springframework.aop.support.AopUtils;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.cache.Cache;
import org.qubership.profiler.shaded.org.springframework.cache.interceptor.CacheEvaluationContext;
import org.qubership.profiler.shaded.org.springframework.cache.interceptor.CacheExpressionRootObject;
import org.qubership.profiler.shaded.org.springframework.context.expression.AnnotatedElementKey;
import org.qubership.profiler.shaded.org.springframework.context.expression.BeanFactoryResolver;
import org.qubership.profiler.shaded.org.springframework.context.expression.CachedExpressionEvaluator;
import org.qubership.profiler.shaded.org.springframework.expression.EvaluationContext;
import org.qubership.profiler.shaded.org.springframework.expression.Expression;

class CacheOperationExpressionEvaluator
extends CachedExpressionEvaluator {
    public static final Object NO_RESULT = new Object();
    public static final Object RESULT_UNAVAILABLE = new Object();
    public static final String RESULT_VARIABLE = "result";
    private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> keyCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>(64);
    private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> conditionCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>(64);
    private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> unlessCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>(64);
    private final Map<AnnotatedElementKey, Method> targetMethodCache = new ConcurrentHashMap<AnnotatedElementKey, Method>(64);

    CacheOperationExpressionEvaluator() {
    }

    public EvaluationContext createEvaluationContext(Collection<? extends Cache> caches, Method method, Object[] args, Object target, Class<?> targetClass, BeanFactory beanFactory) {
        return this.createEvaluationContext(caches, method, args, target, targetClass, NO_RESULT, beanFactory);
    }

    public EvaluationContext createEvaluationContext(Collection<? extends Cache> caches, Method method, Object[] args, Object target, Class<?> targetClass, Object result, BeanFactory beanFactory) {
        CacheExpressionRootObject rootObject = new CacheExpressionRootObject(caches, method, args, target, targetClass);
        Method targetMethod = this.getTargetMethod(targetClass, method);
        CacheEvaluationContext evaluationContext = new CacheEvaluationContext(rootObject, targetMethod, args, this.getParameterNameDiscoverer());
        if (result == RESULT_UNAVAILABLE) {
            evaluationContext.addUnavailableVariable(RESULT_VARIABLE);
        } else if (result != NO_RESULT) {
            evaluationContext.setVariable(RESULT_VARIABLE, result);
        }
        if (beanFactory != null) {
            evaluationContext.setBeanResolver(new BeanFactoryResolver(beanFactory));
        }
        return evaluationContext;
    }

    public Object key(String keyExpression, AnnotatedElementKey methodKey, EvaluationContext evalContext) {
        return this.getExpression(this.keyCache, methodKey, keyExpression).getValue(evalContext);
    }

    public boolean condition(String conditionExpression, AnnotatedElementKey methodKey, EvaluationContext evalContext) {
        return this.getExpression(this.conditionCache, methodKey, conditionExpression).getValue(evalContext, Boolean.TYPE);
    }

    public boolean unless(String unlessExpression, AnnotatedElementKey methodKey, EvaluationContext evalContext) {
        return this.getExpression(this.unlessCache, methodKey, unlessExpression).getValue(evalContext, Boolean.TYPE);
    }

    void clear() {
        this.keyCache.clear();
        this.conditionCache.clear();
        this.unlessCache.clear();
        this.targetMethodCache.clear();
    }

    private Method getTargetMethod(Class<?> targetClass, Method method) {
        AnnotatedElementKey methodKey = new AnnotatedElementKey(method, targetClass);
        Method targetMethod = this.targetMethodCache.get(methodKey);
        if (targetMethod == null) {
            targetMethod = AopUtils.getMostSpecificMethod(method, targetClass);
            if (targetMethod == null) {
                targetMethod = method;
            }
            this.targetMethodCache.put(methodKey, targetMethod);
        }
        return targetMethod;
    }
}

