/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.core.convert.ConversionService;
import org.qubership.profiler.shaded.org.springframework.core.convert.TypeDescriptor;
import org.qubership.profiler.shaded.org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.qubership.profiler.shaded.org.springframework.core.convert.converter.GenericConverter;
import org.qubership.profiler.shaded.org.springframework.core.convert.support.ConversionUtils;

final class ObjectToArrayConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public ObjectToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object[].class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return ConversionUtils.canConvertElements(sourceType, targetType.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        Object target = Array.newInstance(targetType.getElementTypeDescriptor().getType(), 1);
        Object targetElement = this.conversionService.convert(source, sourceType, targetType.getElementTypeDescriptor());
        Array.set(target, 0, targetElement);
        return target;
    }
}

