/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.expression.spel.support;

import org.qubership.profiler.shaded.org.springframework.core.convert.ConversionException;
import org.qubership.profiler.shaded.org.springframework.core.convert.ConversionService;
import org.qubership.profiler.shaded.org.springframework.core.convert.TypeDescriptor;
import org.qubership.profiler.shaded.org.springframework.core.convert.support.DefaultConversionService;
import org.qubership.profiler.shaded.org.springframework.expression.TypeConverter;
import org.qubership.profiler.shaded.org.springframework.expression.spel.SpelEvaluationException;
import org.qubership.profiler.shaded.org.springframework.expression.spel.SpelMessage;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public class StandardTypeConverter
implements TypeConverter {
    private final ConversionService conversionService;

    public StandardTypeConverter() {
        this.conversionService = DefaultConversionService.getSharedInstance();
    }

    public StandardTypeConverter(ConversionService conversionService) {
        Assert.notNull(conversionService, "ConversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType, targetType);
    }

    @Override
    public Object convertValue(Object value, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.conversionService.convert(value, sourceType, targetType);
        }
        catch (ConversionException ex) {
            throw new SpelEvaluationException(ex, SpelMessage.TYPE_CONVERSION_ERROR, sourceType.toString(), targetType.toString());
        }
    }
}

