/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.objenesis.instantiator.sun;

import java.io.NotSerializableException;
import java.lang.reflect.Constructor;
import org.qubership.profiler.shaded.org.springframework.objenesis.ObjenesisException;
import org.qubership.profiler.shaded.org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.qubership.profiler.shaded.org.springframework.objenesis.instantiator.SerializationInstantiatorHelper;
import org.qubership.profiler.shaded.org.springframework.objenesis.instantiator.annotations.Instantiator;
import org.qubership.profiler.shaded.org.springframework.objenesis.instantiator.annotations.Typology;
import org.qubership.profiler.shaded.org.springframework.objenesis.instantiator.sun.SunReflectionFactoryHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Instantiator(value=Typology.SERIALIZATION)
public class SunReflectionFactorySerializationInstantiator<T>
implements ObjectInstantiator<T> {
    private final Constructor<T> mungedConstructor;

    public SunReflectionFactorySerializationInstantiator(Class<T> type) {
        Constructor<T> nonSerializableAncestorConstructor;
        Class<T> nonSerializableAncestor = SerializationInstantiatorHelper.getNonSerializableSuperClass(type);
        try {
            nonSerializableAncestorConstructor = nonSerializableAncestor.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            throw new ObjenesisException(new NotSerializableException(type + " has no suitable superclass constructor"));
        }
        this.mungedConstructor = SunReflectionFactoryHelper.newConstructorForSerialization(type, nonSerializableAncestorConstructor);
        this.mungedConstructor.setAccessible(true);
    }

    @Override
    public T newInstance() {
        try {
            return this.mungedConstructor.newInstance(null);
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }
}

