/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler;

import java.util.Scanner;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class ServerNameResolver {
    private static final Logger logger = LoggerFactory.getLogger(ServerNameResolver.class);
    public static final String PARAM_POD_NAME = "POD_NAME";
    public static final String DEFAULT_SERVER_NAME = "default";
    public static final String POD_NAME = ServerNameResolver.parsePODName();
    public static final String SERVER_NAME = System.getProperty("org.qubership.esc.serverName", System.getProperty("weblogic.Name", System.getProperty("jboss.server.name", POD_NAME)));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parsePODName() {
        String result = ServerNameResolver.getPropertyOrEnvVariable(PARAM_POD_NAME);
        if (!ServerNameResolver.isBlank(result)) {
            return result;
        }
        try (Scanner s = new Scanner(Runtime.getRuntime().exec("hostname").getInputStream()).useDelimiter("\\A");){
            if (!s.hasNext()) return DEFAULT_SERVER_NAME;
            String string = s.next().trim();
            return string;
        }
        catch (Throwable t) {
            logger.warn("Exception in getting hostname", t);
        }
        return DEFAULT_SERVER_NAME;
    }

    public static String getPropertyOrEnvVariable(String paramName) {
        String result = System.getProperty(paramName);
        if (!ServerNameResolver.isBlank(result)) {
            return result.trim();
        }
        result = System.getenv(paramName);
        if (!ServerNameResolver.isBlank(result)) {
            return result.trim();
        }
        return null;
    }

    public static int getPropertyOrEnvVariable(String paramName, int defaultValue) {
        String strVal = ServerNameResolver.getPropertyOrEnvVariable(paramName);
        if (strVal == null || strVal.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(strVal);
    }

    public static String getPropertyOrEnvVariable(String paramName, String defaultValue) {
        String strVal = ServerNameResolver.getPropertyOrEnvVariable(paramName);
        if (strVal == null || strVal.length() == 0) {
            return defaultValue;
        }
        return strVal;
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    static {
        if (System.getProperty("org.qubership.esc.serverName") == null) {
            System.setProperty("org.qubership.esc.serverName", SERVER_NAME);
        }
    }
}

