/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.IOException;
import java.io.InputStream;
import org.qubership.profiler.io.InputStreamProcessor;
import org.qubership.profiler.io.LimitedInputStream;
import org.qubership.profiler.io.exceptions.ErrorSupervisor;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class LimitedInputStreamProcessor
implements InputStreamProcessor {
    public static final Logger log = LoggerFactory.getLogger(LimitedInputStreamProcessor.class);
    private final InputStreamProcessor out;
    private long offset;
    private long length;

    public LimitedInputStreamProcessor(InputStreamProcessor out, long offset, long length) {
        this.out = out;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public boolean process(InputStream is, String name) {
        boolean needContinue = true;
        try {
            if (this.offset != 0L) {
                long skip = is.skip(this.offset);
                this.offset -= skip;
                if (this.offset > 0L) {
                    return true;
                }
            }
            LimitedInputStream limitIS = null;
            if (this.length != Long.MAX_VALUE) {
                if (this.length < 0L) {
                    return false;
                }
                limitIS = new LimitedInputStream(is, this.length);
                is = limitIS;
            }
            needContinue = this.out.process(is, null);
            if (limitIS != null) {
                this.length -= limitIS.position();
            }
        }
        catch (IOException e) {
            ErrorSupervisor.getInstance().warn("Error while processing " + name, e);
        }
        return needContinue;
    }
}

