/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.io.ReactorChainsResolver;
import org.qubership.profiler.shaded.org.apache.commons.lang.StringUtils;
import org.qubership.profiler.shaded.org.springframework.beans.factory.annotation.Value;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Profile;
import org.qubership.profiler.shaded.org.springframework.stereotype.Component;

@Component
@Profile(value={"filestorage"})
public class ReactorChainsResolverFile
extends ReactorChainsResolver {
    @Value(value="${org.qubership.profiler.DUMP_ROOT_LOCATION}")
    private File rootFile;

    @Override
    protected DataInputStreamEx openReactorCallsStream(String folderName, int sequence) throws IOException {
        LinkedList<File> toTraverse = new LinkedList<File>();
        toTraverse.add(new File(this.rootFile, folderName));
        while (toTraverse.size() > 0) {
            File[] children;
            File cur = (File)toTraverse.pop();
            if (!cur.isDirectory() || ".".equals(cur.getName()) || "..".equals(cur.getName()) || (children = cur.listFiles()) == null) continue;
            if ("reactor_calls".equals(cur.getName())) {
                for (File f : children) {
                    String name;
                    if (!f.isFile() || !StringUtils.isNumeric(name = StringUtils.replace(f.getName(), ".gz", "")) || Integer.parseInt(name) != sequence) continue;
                    return DataInputStreamEx.openDataInputStream(f);
                }
                continue;
            }
            toTraverse.addAll(Arrays.asList(children));
        }
        return null;
    }
}

