/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io.call;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.io.Call;
import org.qubership.profiler.io.call.CallDataReader;

public abstract class CallDataReaderBase
implements CallDataReader {
    @Override
    public void readParams(Call dst, DataInputStreamEx calls, BitSet requiredIds) throws IOException {
        int len;
        if (dst.params != null && dst.params.size() > 0) {
            dst.params.clear();
        }
        if ((len = calls.readVarInt()) == 0) {
            return;
        }
        if (dst.params == null) {
            dst.params = new HashMap<Integer, List<String>>(len, 1.0f);
        }
        while (len > 0) {
            int paramId = calls.readVarInt();
            requiredIds.set(paramId);
            int size = calls.readVarInt();
            if (size == 0) {
                dst.params.put(paramId, Collections.emptyList());
            } else if (size == 1) {
                dst.params.put(paramId, Collections.singletonList(calls.readString()));
            } else {
                String[] result = new String[size];
                --size;
                while (size >= 0) {
                    result[size] = calls.readString();
                    --size;
                }
                dst.params.put(paramId, Arrays.asList(result));
            }
            --len;
        }
    }

    @Override
    public void skipParams(Call dst, DataInputStreamEx calls) throws IOException {
        if (dst.params != null && dst.params.size() > 0) {
            dst.params.clear();
        }
        for (int len = calls.readVarInt(); len > 0; --len) {
            int paramId = calls.readVarInt();
            for (int size = calls.readVarInt(); size > 0; --size) {
                calls.skipString();
            }
        }
    }

    @Override
    public void postCompute(ArrayList<Call> result, List<String> tags, BitSet requredIds) {
    }
}

