/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.servlet;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.profiler.io.CallFilterer;
import org.qubership.profiler.io.CallReaderFactory;
import org.qubership.profiler.io.CallToJS;
import org.qubership.profiler.io.DurationFiltererImpl;
import org.qubership.profiler.io.ICallReader;
import org.qubership.profiler.io.JSHelper;
import org.qubership.profiler.io.TemporalRequestParams;
import org.qubership.profiler.io.TemporalUtils;
import org.qubership.profiler.servlet.Installer;
import org.qubership.profiler.servlet.SpringBootInitializer;
import org.qubership.profiler.servlet.util.DumperStatusProvider;
import org.qubership.profiler.shaded.org.apache.commons.lang.BooleanUtils;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.util.TimeHelper;

public class CallFetcher
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(CallFetcher.class);
    private static final int RESPONSE_BUFFER_SIZE = Integer.getInteger(CallFetcher.class.getName() + ".RESPONSE_BUFFER_SIZE", 256);

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isExternalScript = request.getServletPath().endsWith(".js");
        if (isExternalScript) {
            response.setBufferSize(RESPONSE_BUFFER_SIZE);
            response.setContentType("application/x-javascript; charset=utf-8");
        }
        PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8"), 10240), false);
        TemporalRequestParams temporal = TemporalUtils.parseTemporal(request);
        String callback = request.getParameter("callback");
        if (callback == null) {
            callback = isExternalScript ? "dataReceived" : "callsdata";
        }
        callback = URLEncoder.encode(callback, "UTF-8");
        out.print(callback);
        out.print('(');
        String requestId = URLEncoder.encode(request.getParameter("id"), "UTF-8");
        out.print(requestId);
        out.print(", function(){");
        this.printStartupInfo(requestId, out, temporal);
        LinkedList<Throwable> exceptions = new LinkedList<Throwable>();
        try {
            List<ICallReader> readers = this.collectCallReaders(request, out, temporal);
            out.print("var er=isDump.addProperty(\"");
            out.print(this.readingFromFileDump());
            out.print("\"");
            out.println(");");
            for (ICallReader cr : readers) {
                cr.find();
                exceptions.addAll(cr.getExceptions());
            }
        }
        catch (Exception e) {
            exceptions.add(e);
            log.error("Failed to read profiler calls: ", e);
        }
        StringBuilder sb = new StringBuilder();
        for (Throwable t : exceptions) {
            log.error("Reporting the following exception: ", t);
            sb.append(t.getMessage());
            sb.append("\n");
        }
        if (sb.length() > 0) {
            out.print("app.notify.notify('create', 'jqn-error', {title:'Errors occurred',text:\"");
            JSHelper.escapeJS(out, sb.toString());
            out.print("\"}, {expires:false, custom: true});\n");
        }
        out.print("},{timerange:{");
        out.print("min:");
        out.print(temporal.timerangeFrom);
        out.print(",max:");
        out.print(temporal.timerangeTo);
        out.print(",autoUpdate:");
        out.print(temporal.autoUpdate);
        out.print("}, duration:{");
        out.print("min:");
        out.print(temporal.durationFrom);
        if (temporal.durationTo != Long.MAX_VALUE) {
            out.print(",max:");
            out.print(temporal.durationTo);
        }
        out.print("},availableServices:");
        this.printAvailableServices(out);
        out.print("});");
        out.flush();
    }

    protected void printStartupInfo(String requestId, PrintWriter out, TemporalRequestParams temporal) throws IOException {
        if ("0".equals(requestId)) {
            String nonLoaded = Installer.getNonActiveProfilerWarning();
            if (nonLoaded != null) {
                out.print("app.notify.notify('create', 'jqn-error', {title:'Profiler is not active',text:\"Profiler gathering agent is not runnig.<br>");
                JSHelper.escapeJS(out, nonLoaded);
                out.print("\"}, {expires:false, custom: true});\n");
            }
            this.printServerClockWarning(temporal.serverUTC, temporal.clientUTC, out);
            this.printStartupRequirements(out);
        }
    }

    protected boolean readingFromFileDump() {
        return BooleanUtils.toBoolean(SpringBootInitializer.getIsReadFromDumpProperty());
    }

    protected CallReaderFactory callReaderFactory() {
        return SpringBootInitializer.callReaderFactory();
    }

    protected CallToJS callToJs(PrintWriter out, CallFilterer cf) {
        return SpringBootInitializer.callToJs(out, cf);
    }

    private List<ICallReader> collectCallReaders(HttpServletRequest request, PrintWriter out, TemporalRequestParams temporal) throws IOException {
        DurationFiltererImpl cf = new DurationFiltererImpl(temporal.durationFrom, temporal.durationTo);
        return this.callReaderFactory().collectCallReaders(request.getParameterMap(), temporal, this.callToJs(out, cf), cf);
    }

    private void printStartupRequirements(PrintWriter out) throws IOException {
        DumperStatusProvider dumper = DumperStatusProvider.INSTANCE;
        dumper.update();
        if (!dumper.isStarted) {
            return;
        }
        List<String> recommendations = Installer.getStartupArgumentRecommendations();
        for (String recommendation : recommendations) {
            out.print("app.notify.notify('create', 'jqn-error', {title:'Startup arguments misconfiguration',text:\"");
            JSHelper.escapeJS(out, recommendation);
            out.print("\"}, {expires: 10000, custom: true});\n");
        }
    }

    protected List<String[]> getAvailableServices() {
        return SpringBootInitializer.loggedContainersInfo().listPodDetails();
    }

    private void printAvailableServices(PrintWriter out) {
        List<String[]> podDetails = this.getAvailableServices();
        if (podDetails == null) {
            out.write("null");
            return;
        }
        out.write("{");
        this.printList(out, "podNames", podDetails, 0);
        out.write(",");
        this.printList(out, "serviceNames", podDetails, 1);
        out.write(",");
        this.printList(out, "namespaces", podDetails, 2);
        out.write("}");
    }

    private void printList(PrintWriter out, String listName, List<String[]> list, int index) {
        TreeSet<String> distinctList = new TreeSet<String>();
        for (String[] src : list) {
            distinctList.add(src[index]);
        }
        out.write(listName);
        out.write(":[");
        Iterator it = distinctList.iterator();
        while (it.hasNext()) {
            out.write("\"");
            out.write((String)it.next());
            out.write("\"");
            if (!it.hasNext()) continue;
            out.write(",");
        }
        out.write("]");
    }

    private void printServerClockWarning(long serverUTC, long clientUTC, PrintWriter out) {
        long diffInSeconds = Math.abs(serverUTC - clientUTC) / 1000L;
        if (diffInSeconds <= 10L) {
            return;
        }
        out.print("app.notify.notify('create', 'jqn-error', {title:'Server clock might be wrong',text:\"Looks like server clock is ");
        out.print(TimeHelper.humanizeDifference(null, serverUTC - clientUTC));
        out.print("<br>Take this difference into consideration when applying timerange filters.<br>Ask IT to enable NTP time synchronization on both client and server\"}, {expires:false, custom: true});\n");
    }
}

