/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressedHttpServletRequest;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingFilterContext;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingHttpServletResponse;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingStreamFactory;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStats;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public final class CompressingFilter
implements Filter {
    public static final String FORCE_ENCODING_KEY = "com.planet.servlet.filter.compression.ForceEncoding";
    public static final String COMPRESSED_KEY = "org.qubership.profiler.shaded.com.github.ziplet.filter.compression.Compressed";
    static final String VARY_HEADER = "Vary";
    static final String VERSION = "1.7.1";
    static final String VERSION_STRING = CompressingFilter.class.getName() + '/' + "1.7.1";
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressingFilter.class);
    private static final String ALREADY_APPLIED_KEY = "org.qubership.profiler.shaded.com.github.ziplet.filter.compression.AlreadyApplied";
    private CompressingFilterContext context;
    private CompressingFilterStats stats;

    @Override
    public void init(FilterConfig config) throws ServletException {
        assert (config != null);
        this.context = new CompressingFilterContext(config);
        if (this.stats != null) {
            this.context.setCompressingFilterStats(this.stats);
        }
        LOGGER.info("CompressingFilter has initialized");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean attemptingToCompressResponse;
        ServletRequest chainRequest = this.getRequest(request);
        ServletResponse chainResponse = this.getResponse(request, response);
        boolean attemptingToDecompressRequest = chainRequest != null;
        boolean bl = attemptingToCompressResponse = chainResponse != null;
        if (chainRequest == null) {
            chainRequest = request;
        }
        if (chainResponse == null) {
            chainResponse = response;
        }
        if (attemptingToDecompressRequest) {
            this.context.getStats().incrementNumRequestsCompressed();
        } else {
            this.context.getStats().incrementTotalRequestsNotCompressed();
        }
        request.setAttribute(ALREADY_APPLIED_KEY, Boolean.TRUE);
        chain.doFilter(chainRequest, chainResponse);
        if (attemptingToCompressResponse) {
            CompressingHttpServletResponse compressingResponse = (CompressingHttpServletResponse)chainResponse;
            LOGGER.debug("Closing the response (if not already closed)...");
            try {
                compressingResponse.close();
            }
            catch (IOException ioe) {
                LOGGER.debug("Error while flushing buffer", ioe);
            }
            if (compressingResponse.isCompressing()) {
                chainRequest.setAttribute(COMPRESSED_KEY, Boolean.TRUE);
            }
            this.context.getStats().incrementNumResponsesCompressed();
        } else {
            this.context.getStats().incrementTotalResponsesNotCompressed();
        }
    }

    private ServletRequest getRequest(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            LOGGER.debug("Can't compress non-HTTP request");
            return null;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String contentEncoding = httpRequest.getHeader("Content-Encoding");
        if (contentEncoding == null) {
            LOGGER.debug("Request is not compressed, so not decompressing");
            return null;
        }
        if (!CompressingStreamFactory.isSupportedRequestContentEncoding(contentEncoding)) {
            LOGGER.debug("Can't decompress request with encoding: " + contentEncoding);
            return null;
        }
        return new CompressedHttpServletRequest(httpRequest, CompressingStreamFactory.getFactoryForContentEncoding(contentEncoding), this.context);
    }

    private ServletResponse getResponse(ServletRequest request, ServletResponse response) {
        String requestURI;
        if (response.isCommitted() || request.getAttribute(ALREADY_APPLIED_KEY) != null) {
            LOGGER.debug("Response committed or filter has already been applied");
            return null;
        }
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            LOGGER.debug("Can't compress non-HTTP request, response");
            return null;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Request for: '" + httpRequest.getRequestURI() + '\'');
        }
        if (!this.isCompressablePath(requestURI = httpRequest.getRequestURI())) {
            LOGGER.debug("Compression disabled for path: " + requestURI);
            return null;
        }
        String userAgent = httpRequest.getHeader("User-Agent");
        if (!this.isCompressableUserAgent(userAgent)) {
            LOGGER.debug("Compression disabled for User-Agent: " + userAgent);
            return null;
        }
        this.setVaryHeader(httpResponse, userAgent);
        String contentEncoding = CompressingStreamFactory.getBestContentEncoding(httpRequest);
        assert (contentEncoding != null);
        if ("identity".equals(contentEncoding)) {
            LOGGER.debug("Compression not supported or declined by request");
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compression supported; using content encoding '" + contentEncoding + '\'');
        }
        CompressingStreamFactory compressingStreamFactory = CompressingStreamFactory.getFactoryForContentEncoding(contentEncoding);
        return new CompressingHttpServletResponse(httpResponse, compressingStreamFactory, contentEncoding, this.context);
    }

    void setVaryHeader(HttpServletResponse httpResponse, String userAgent) {
        if (this.sendVaryHeader(userAgent)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting Vary Header because the response *could be compressed*. Vary : Accept-Encoding");
            }
            httpResponse.addHeader(VARY_HEADER, "Accept-Encoding");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Vary header not set, because user agent should not receive the header");
        }
    }

    @Override
    public void destroy() {
        LOGGER.info("CompressingFilter is being destroyed...");
    }

    private boolean isCompressablePath(String path) {
        if (path != null) {
            for (Pattern pattern : this.context.getPathPatterns()) {
                if (!pattern.matcher(path).matches()) continue;
                return this.context.isIncludePathPatterns();
            }
        }
        return !this.context.isIncludePathPatterns();
    }

    private boolean isCompressableUserAgent(String userAgent) {
        if (userAgent != null) {
            for (Pattern pattern : this.context.getUserAgentPatterns()) {
                if (!pattern.matcher(userAgent).matches()) continue;
                return this.context.isIncludeUserAgentPatterns();
            }
        }
        return !this.context.isIncludeUserAgentPatterns();
    }

    private boolean sendVaryHeader(String userAgent) {
        if (userAgent != null) {
            for (Pattern pattern : this.context.getNoVaryHeaderPatterns()) {
                if (!pattern.matcher(userAgent).matches()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return VERSION_STRING;
    }

    public void setCompressingFilterStats(CompressingFilterStats stats) {
        this.stats = stats;
    }
}

