/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.IOException;
import java.io.OutputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.StatsField;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStats;

public class StatsOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    protected final CompressingFilterStats stats;
    private final StatsField field;

    StatsOutputStream(OutputStream outputStream, CompressingFilterStats stats, StatsField field) {
        assert (outputStream != null && stats != null);
        this.outputStream = outputStream;
        this.stats = stats;
        this.field = field;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        this.notifyBytesWritten(1L);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        if (b != null && b.length > 0) {
            this.notifyBytesWritten(b.length);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        if (len > 0) {
            this.notifyBytesWritten(len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public String toString() {
        return "StatsOutputStream[" + this.outputStream + ']';
    }

    private void notifyBytesWritten(long result) {
        switch (this.field) {
            case RESPONSE_INPUT_BYTES: {
                this.stats.notifyResponseBytesWritten(result);
                break;
            }
            case RESPONSE_COMPRESSED_BYTES: {
                this.stats.notifyCompressedResponseBytesWritten(result);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

