/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.net.sourceforge.argparse4j;

import java.util.Locale;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.ArgumentParsers;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.DefaultSettings;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.helper.ASCIITextWidthCounter;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.helper.CJKTextWidthCounter;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.helper.TextWidthCounter;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.ArgumentParser;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.internal.ArgumentParserConfigurationImpl;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.internal.ArgumentParserImpl;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.internal.TerminalWidth;

public class ArgumentParserBuilder {
    private final String prog_;
    private boolean addHelp_ = true;
    private String prefixChars_ = "-";
    private String fromFilePrefix_ = null;
    private Locale locale_ = Locale.getDefault();
    private boolean cjkWidthHack_ = true;
    private int defaultFormatWidth_ = 75;
    private boolean terminalWidthDetection_ = true;
    private boolean singleMetavar_ = false;
    private boolean noDestConversionForPositionalArgs_ = false;
    private boolean includeArgumentNamesAsKeysInResult_ = false;
    boolean mustHelpTextIncludeMutualExclusivity_ = false;

    ArgumentParserBuilder(String prog, DefaultSettings defaultSettings) {
        this.prog_ = prog;
        defaultSettings.apply(this);
    }

    public ArgumentParserBuilder addHelp(boolean flag) {
        this.addHelp_ = flag;
        return this;
    }

    public ArgumentParserBuilder prefixChars(String prefixChars) {
        this.prefixChars_ = prefixChars;
        return this;
    }

    public ArgumentParserBuilder fromFilePrefix(String fromFilePrefix) {
        this.fromFilePrefix_ = fromFilePrefix;
        return this;
    }

    public ArgumentParserBuilder locale(Locale locale) {
        this.locale_ = locale;
        return this;
    }

    public ArgumentParserBuilder cjkWidthHack(boolean flag) {
        this.cjkWidthHack_ = flag;
        return this;
    }

    public ArgumentParserBuilder defaultFormatWidth(int defaultFormatWidth) {
        this.defaultFormatWidth_ = defaultFormatWidth;
        return this;
    }

    public ArgumentParserBuilder terminalWidthDetection(boolean flag) {
        this.terminalWidthDetection_ = flag;
        return this;
    }

    public ArgumentParserBuilder singleMetavar(boolean flag) {
        this.singleMetavar_ = flag;
        return this;
    }

    public ArgumentParserBuilder noDestConversionForPositionalArgs(boolean flag) {
        this.noDestConversionForPositionalArgs_ = flag;
        return this;
    }

    public ArgumentParserBuilder includeArgumentNamesAsKeysInResult(boolean flag) {
        this.includeArgumentNamesAsKeysInResult_ = flag;
        return this;
    }

    public ArgumentParserBuilder mustHelpTextIncludeMutualExclusivity(boolean flag) {
        this.mustHelpTextIncludeMutualExclusivity_ = flag;
        return this;
    }

    public ArgumentParser build() {
        return new ArgumentParserImpl(this.config());
    }

    private ArgumentParserConfigurationImpl config() {
        return new ArgumentParserConfigurationImpl(this.prog_, this.addHelp_, this.prefixChars_, this.fromFilePrefix_, this.locale_, this.createTextWidthCounter(), this.getFormatWidth(), this.singleMetavar_, this.noDestConversionForPositionalArgs_, this.includeArgumentNamesAsKeysInResult_, this.mustHelpTextIncludeMutualExclusivity_);
    }

    private TextWidthCounter createTextWidthCounter() {
        return this.cjkWidthHack_ && ArgumentParsers.cjkWidthLangs_.contains(this.locale_.getLanguage()) ? new CJKTextWidthCounter() : new ASCIITextWidthCounter();
    }

    private int getFormatWidth() {
        if (this.terminalWidthDetection_) {
            int w = new TerminalWidth().getTerminalWidth() - 5;
            return w <= 0 ? this.defaultFormatWidth_ : w;
        }
        return this.defaultFormatWidth_;
    }
}

