/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.net.sourceforge.argparse4j.impl.choice;

import java.util.Arrays;
import java.util.Collection;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.helper.TextHelper;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.ArgumentChoice;

public class CollectionArgumentChoice<E>
implements ArgumentChoice {
    private final Collection<E> values_;

    @SafeVarargs
    public CollectionArgumentChoice(E ... values) {
        this.values_ = Arrays.asList(values);
    }

    public CollectionArgumentChoice(Collection<E> values) {
        this.values_ = values;
    }

    @Override
    public boolean contains(Object val) {
        if (this.values_.isEmpty()) {
            return false;
        }
        E first = this.values_.iterator().next();
        if (first.getClass().equals(val.getClass()) || first instanceof Enum && val instanceof Enum && ((Enum)first).getDeclaringClass().equals(((Enum)val).getDeclaringClass())) {
            return this.values_.contains(val);
        }
        throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "type mismatch (Make sure that you specified correct Argument.type()): expected: %s actual: %s", first.getClass().getName(), val.getClass().getName()));
    }

    @Override
    public String textualFormat() {
        return TextHelper.concat(this.values_, 0, ",", "{", "}");
    }

    public String toString() {
        return this.textualFormat();
    }
}

