/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.net.sourceforge.argparse4j.impl.type;

import org.qubership.profiler.shaded.net.sourceforge.argparse4j.helper.MessageLocalization;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.helper.TextHelper;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.Argument;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.ArgumentParser;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.ArgumentType;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.MetavarInference;

public class EnumStringArgumentType<T extends Enum<T>>
implements ArgumentType<T>,
MetavarInference {
    private final Class<T> type_;

    public EnumStringArgumentType(Class<T> type) {
        this.type_ = type;
    }

    public static <T extends Enum<T>> EnumStringArgumentType<T> forEnum(Class<T> type) {
        return new EnumStringArgumentType<T>(type);
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        for (Enum t : (Enum[])this.type_.getEnumConstants()) {
            if (!t.toString().equals(value)) continue;
            return (T)t;
        }
        String choices = TextHelper.concat((Enum[])this.type_.getEnumConstants(), 0, ",", "{", "}");
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, MessageLocalization.localize(parser.getConfig().getResourceBundle(), "couldNotConvertChooseFromError"), value, choices), parser, arg);
    }

    @Override
    public String[] inferMetavar() {
        return new String[]{TextHelper.concat((Enum[])this.type_.getEnumConstants(), 0, ",", "{", "}")};
    }
}

