/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.net.sourceforge.argparse4j.internal;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.helper.TextHelper;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.ArgumentGroup;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.internal.ArgumentImpl;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.internal.ArgumentParserImpl;

public final class ArgumentGroupImpl
implements ArgumentGroup,
MutuallyExclusiveGroup {
    private int index_;
    private final String title_;
    private String description_ = "";
    private final ArgumentParserImpl argumentParser_;
    private final List<ArgumentImpl> args_ = new ArrayList<ArgumentImpl>();
    private boolean mutex_ = false;
    private boolean required_ = false;

    ArgumentGroupImpl(ArgumentParserImpl argumentParser, String title) {
        this.argumentParser_ = argumentParser;
        this.title_ = TextHelper.nonNull(title);
    }

    @Override
    public ArgumentGroupImpl description(String description) {
        this.description_ = TextHelper.nonNull(description);
        return this;
    }

    @Override
    public ArgumentImpl addArgument(String ... nameOrFlags) {
        ArgumentImpl arg = this.argumentParser_.addArgument(this, nameOrFlags);
        this.args_.add(arg);
        return arg;
    }

    @Override
    public ArgumentGroupImpl required(boolean required) {
        this.required_ = required;
        return this;
    }

    public void printHelp(PrintWriter writer, int format_width) {
        if (!this.title_.isEmpty()) {
            writer.print(this.title_);
            writer.println(":");
        }
        if (!this.description_.isEmpty()) {
            writer.print("  ");
            writer.println(TextHelper.wrap(this.argumentParser_.getTextWidthCounter(), this.description_, format_width, 2, "", "  "));
            writer.println();
        }
        if (this.mutex_ && this.argumentParser_.getConfig().mustHelpTextIncludeMutualExclusivity_) {
            writer.print("  ");
            String mutualExclusiveExplanation = this.argumentParser_.localize(this.required_ ? "help.exactlyOneArgumentMustBeGiven" : "help.atMostOneArgumentMayBeGiven");
            writer.println(TextHelper.wrap(this.argumentParser_.getTextWidthCounter(), mutualExclusiveExplanation, format_width, 2, "", "  "));
            writer.println();
        }
        for (ArgumentImpl arg : this.args_) {
            arg.printHelp(writer, this.argumentParser_.isDefaultHelp(), this.argumentParser_.getTextWidthCounter(), format_width);
        }
    }

    int getIndex() {
        return this.index_;
    }

    void setIndex(int index) {
        this.index_ = index;
    }

    boolean isMutex() {
        return this.mutex_;
    }

    void setMutex(boolean mutex) {
        this.mutex_ = mutex;
    }

    public boolean isRequired() {
        return this.required_;
    }

    public List<ArgumentImpl> getArgs() {
        return this.args_;
    }

    boolean isSeparateHelp() {
        return !this.mutex_ || !this.title_.isEmpty() || !this.description_.isEmpty();
    }
}

