/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCMethod;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.messages.internal.Messages;

public interface IMCFrame {
    public Integer getFrameLineNumber();

    public Integer getBCI();

    public IMCMethod getMethod();

    public Type getType();

    public static final class Type {
        public static final Type JIT_COMPILED = new Type("JIT_COMPILED");
        public static final Type INTERPRETED = new Type("INTERPRETED");
        public static final Type INLINED = new Type("INLINED");
        public static final Type NATIVE = new Type("NATIVE");
        public static final Type CPP = new Type("CPP");
        public static final Type KERNEL = new Type("KERNEL");
        public static final Type UNKNOWN = new Type("UNKNONW");
        private static final String MSG_PREFIX = "IMCFrame_Type_";
        private static final int TYPE_CACHE_MAX_SIZE = 100;
        private static final Map<String, Type> TYPE_CACHE = new LinkedHashMap<String, Type>(){
            private static final long serialVersionUID = 6330800425284157773L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Type> eldest) {
                return this.size() > 100;
            }
        };
        private final String id;
        private final String name;
        private final boolean isUnknown;

        private Type(String id) {
            this.id = id.toUpperCase();
            String key = MSG_PREFIX + this.id;
            if (Messages.hasString(key)) {
                this.name = Messages.getString(key);
                this.isUnknown = false;
            } else {
                this.name = this.id;
                this.isUnknown = true;
            }
        }

        public static Type cachedType(String type) {
            return TYPE_CACHE.computeIfAbsent(type, Type::new);
        }

        public String getName() {
            return this.name;
        }

        public boolean isUnknown() {
            return this.isUnknown;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type type = (Type)o;
            return this.id.equals(type.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

