/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.item;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IState;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IStateful;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IWritableState;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.Attribute;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItemFilter;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.ItemFilters;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IPersister;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.QuantityConversionException;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.RangeContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.UnitLookup;

public abstract class PersistableItemFilter
implements IItemFilter,
IStateful {
    private static final Logger LOGGER = Logger.getLogger("org.qubership.profiler.shaded.org.openjdk.jmc.common.item");
    private static final String KEY_KIND = "kind";
    static final String KEY_FILTER = "filter";
    static final String KEY_FIELD = "field";
    static final String KEY_TYPE = "type";
    static final String KEY_TYPE_MATCHES = "typeMatches";
    static final String KEY_VALUE = "value";
    static final String KEY_START = "start";
    static final String KEY_END = "end";
    protected final Kind kind;

    protected PersistableItemFilter(Kind kind) {
        this.kind = kind;
    }

    @Override
    public final void saveTo(IWritableState memento) {
        memento.putString(KEY_KIND, this.kind.name());
        this.saveArgs(memento);
    }

    protected abstract void saveArgs(IWritableState var1);

    protected static void putValueType(IWritableState memento, ContentType<?> contentType) {
        memento.putString(KEY_TYPE, contentType.getIdentifier());
    }

    public static IItemFilter readFrom(IState memento) {
        Kind kind = Kind.valueOf(memento.getAttribute(KEY_KIND));
        if (kind == null) {
            return null;
        }
        switch (kind) {
            case AND: {
                return ItemFilters.and(PersistableItemFilter.readFrom(memento.getChildren(KEY_FILTER)));
            }
            case OR: {
                return ItemFilters.or(PersistableItemFilter.readFrom(memento.getChildren(KEY_FILTER)));
            }
            case NOT: {
                return ItemFilters.not(PersistableItemFilter.readFrom(memento.getChildren(KEY_FILTER)[0]));
            }
            case MATCHES: {
                return ItemFilters.matches(PersistableItemFilter.readStringAttribute(memento), memento.getAttribute(KEY_VALUE));
            }
            case NOT_MATCHES: {
                return ItemFilters.notMatches(PersistableItemFilter.readStringAttribute(memento), memento.getAttribute(KEY_VALUE));
            }
            case CONTAINS: {
                return ItemFilters.contains(PersistableItemFilter.readStringAttribute(memento), memento.getAttribute(KEY_VALUE));
            }
            case NOT_CONTAINS: {
                return ItemFilters.notContains(PersistableItemFilter.readStringAttribute(memento), memento.getAttribute(KEY_VALUE));
            }
            case EQUALS: {
                return PersistableItemFilter.readEquals(PersistableItemFilter.readAttribute(memento), memento);
            }
            case NOT_EQUALS: {
                return PersistableItemFilter.readNotEquals(PersistableItemFilter.readAttribute(memento), memento);
            }
            case LESS: 
            case LESS_OR_EQUAL: 
            case MORE: 
            case MORE_OR_EQUAL: {
                return PersistableItemFilter.readComparableKindFrom(kind, memento);
            }
            case RANGE_INTERSECTS: 
            case RANGE_CONTAINED: 
            case CENTER_CONTAINED: 
            case RANGE_NOT_INTERSECTS: 
            case RANGE_NOT_CONTAINED: 
            case CENTER_NOT_CONTAINED: {
                return PersistableItemFilter.readRangeMatchesFrom(kind, memento);
            }
            case EXISTS: {
                return ItemFilters.hasAttribute(PersistableItemFilter.readAttribute(memento));
            }
            case NOT_EXISTS: {
                return ItemFilters.notHasAttribute(PersistableItemFilter.readAttribute(memento));
            }
            case TYPE: {
                return ItemFilters.type(memento.getAttribute(KEY_TYPE));
            }
            case TYPE_MATCHES: {
                return ItemFilters.typeMatches(memento.getAttribute(KEY_TYPE_MATCHES));
            }
            case IS_NULL: {
                return ItemFilters.isNull(PersistableItemFilter.readAttribute(memento));
            }
            case IS_NOT_NULL: {
                return ItemFilters.isNotNull(PersistableItemFilter.readAttribute(memento));
            }
        }
        return null;
    }

    private static <M> IItemFilter readEquals(ICanonicalAccessorFactory<M> attribute, IState memento) {
        return ItemFilters.equals(attribute, PersistableItemFilter.readValue(attribute.getContentType().getPersister(), memento));
    }

    private static <M> IItemFilter readNotEquals(ICanonicalAccessorFactory<M> attribute, IState memento) {
        return ItemFilters.notEquals(attribute, PersistableItemFilter.readValue(attribute.getContentType().getPersister(), memento));
    }

    private static <M extends Comparable<? super M>> IItemFilter readComparableKindFrom(Kind kind, IState memento) {
        ICanonicalAccessorFactory<M> attr = PersistableItemFilter.readComparableAttribute(memento);
        return PersistableItemFilter.readComparableKindFrom(attr, kind, memento);
    }

    private static <M extends Comparable<? super M>> IItemFilter readComparableKindFrom(ICanonicalAccessorFactory<M> attribute, Kind kind, IState memento) {
        Comparable value = (Comparable)PersistableItemFilter.readValue(attribute.getContentType().getPersister(), memento);
        switch (kind) {
            case LESS: {
                return ItemFilters.less(attribute, value);
            }
            case LESS_OR_EQUAL: {
                return ItemFilters.lessOrEqual(attribute, value);
            }
            case MORE: {
                return ItemFilters.more(attribute, value);
            }
            case MORE_OR_EQUAL: {
                return ItemFilters.moreOrEqual(attribute, value);
            }
        }
        throw new IllegalArgumentException("Only to be called with LESS, LESS_OR_EQUAL, MORE or MORE_OR_EQUAL kind.");
    }

    private static <M extends Comparable<? super M>> IItemFilter readRangeMatchesFrom(Kind kind, IState memento) {
        ContentType<M> type = PersistableItemFilter.readComparableType(memento);
        RangeContentType<M> rangeType = UnitLookup.getRangeType(type);
        ICanonicalAccessorFactory attr = Attribute.attr(memento.getAttribute(KEY_FIELD), rangeType);
        Comparable start = (Comparable)PersistableItemFilter.readValue(type.getPersister(), memento, KEY_START);
        Comparable end = (Comparable)PersistableItemFilter.readValue(type.getPersister(), memento, KEY_END);
        return ItemFilters.matchRange(kind, attr, rangeType.rangeWithEnd(start, end));
    }

    static <M> M readValue(IPersister<M> persister, IState from) {
        return PersistableItemFilter.readValue(persister, from, KEY_VALUE);
    }

    static <M> M readValue(IPersister<M> persister, IState from, String key) {
        String persistedValue = from.getAttribute(key);
        if (persistedValue != null) {
            try {
                return (M)persister.parsePersisted(persistedValue);
            }
            catch (QuantityConversionException e) {
                LOGGER.log(Level.SEVERE, "Failed to parse value from attibute " + key, e);
            }
        }
        return null;
    }

    static <M> void writeValue(M value, IPersister<M> persister, IWritableState to) {
        PersistableItemFilter.writeValue(value, persister, to, KEY_VALUE);
    }

    static <M> void writeValue(M value, IPersister<M> persister, IWritableState to, String key) {
        if (value != null) {
            to.putString(key, persister.persistableString(value));
        }
    }

    private static IItemFilter[] readFrom(IState[] mementos) {
        IItemFilter[] filters = new IItemFilter[mementos.length];
        for (int i = 0; i < mementos.length; ++i) {
            filters[i] = PersistableItemFilter.readFrom(mementos[i]);
        }
        return filters;
    }

    private static ICanonicalAccessorFactory<String> readStringAttribute(IState memento) {
        return PersistableItemFilter.readAttribute(memento);
    }

    private static <M extends Comparable<? super M>> ContentType<M> readComparableType(IState memento) {
        return UnitLookup.getContentType(memento.getAttribute(KEY_TYPE));
    }

    private static ICanonicalAccessorFactory<?> readAttribute(IState memento) {
        return PersistableItemFilter.createAttribute(memento.getAttribute(KEY_FIELD), UnitLookup.getContentType(memento.getAttribute(KEY_TYPE)));
    }

    private static <M extends Comparable<? super M>> ICanonicalAccessorFactory<M> readComparableAttribute(IState memento) {
        ContentType<M> type = PersistableItemFilter.readComparableType(memento);
        return PersistableItemFilter.createAttribute(memento.getAttribute(KEY_FIELD), type);
    }

    private static <M> ICanonicalAccessorFactory<M> createAttribute(String id, ContentType<M> type) {
        return Attribute.attr(id, type);
    }

    public String toString() {
        return String.valueOf((Object)this.kind);
    }

    public String toString(String argumentName, Object value) {
        return String.format(" %s=%s", argumentName, String.valueOf(value));
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind AND = new Kind();
        public static final /* enum */ Kind OR = new Kind();
        public static final /* enum */ Kind NOT = new Kind();
        public static final /* enum */ Kind EQUALS = new Kind();
        public static final /* enum */ Kind NOT_EQUALS = new Kind(EQUALS);
        public static final /* enum */ Kind MATCHES = new Kind();
        public static final /* enum */ Kind NOT_MATCHES = new Kind(MATCHES);
        public static final /* enum */ Kind CONTAINS = new Kind();
        public static final /* enum */ Kind NOT_CONTAINS = new Kind(CONTAINS);
        public static final /* enum */ Kind LESS = new Kind();
        public static final /* enum */ Kind LESS_OR_EQUAL = new Kind();
        public static final /* enum */ Kind MORE = new Kind(LESS_OR_EQUAL);
        public static final /* enum */ Kind MORE_OR_EQUAL = new Kind(LESS);
        public static final /* enum */ Kind RANGE_INTERSECTS = new Kind();
        public static final /* enum */ Kind RANGE_NOT_INTERSECTS = new Kind(RANGE_INTERSECTS);
        public static final /* enum */ Kind RANGE_CONTAINED = new Kind();
        public static final /* enum */ Kind RANGE_NOT_CONTAINED = new Kind(RANGE_CONTAINED);
        public static final /* enum */ Kind CENTER_CONTAINED = new Kind();
        public static final /* enum */ Kind CENTER_NOT_CONTAINED = new Kind(CENTER_CONTAINED);
        public static final /* enum */ Kind TYPE = new Kind();
        public static final /* enum */ Kind TYPE_MATCHES = new Kind();
        public static final /* enum */ Kind EXISTS = new Kind();
        public static final /* enum */ Kind NOT_EXISTS = new Kind(EXISTS);
        public static final /* enum */ Kind IS_NULL = new Kind();
        public static final /* enum */ Kind IS_NOT_NULL = new Kind(IS_NULL);
        private Kind negatedKind;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        private Kind() {
            this.negatedKind = null;
        }

        private Kind(Kind neg) {
            assert (neg.negatedKind == null);
            this.negatedKind = neg;
            neg.negatedKind = this;
        }

        public Kind negate() {
            return this.negatedKind;
        }

        static {
            $VALUES = new Kind[]{AND, OR, NOT, EQUALS, NOT_EQUALS, MATCHES, NOT_MATCHES, CONTAINS, NOT_CONTAINS, LESS, LESS_OR_EQUAL, MORE, MORE_OR_EQUAL, RANGE_INTERSECTS, RANGE_NOT_INTERSECTS, RANGE_CONTAINED, RANGE_NOT_CONTAINED, CENTER_CONTAINED, CENTER_NOT_CONTAINED, TYPE, TYPE_MATCHES, EXISTS, NOT_EXISTS, IS_NULL, IS_NOT_NULL};
        }
    }
}

