/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Deque;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IState;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IStateful;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IWritableState;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.util.StateElement;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.util.StateElementWriter;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.util.XmlToolkit;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StateToolkit {
    public static void saveXMLDocumentTo(Reader reader, IWritableState state) throws SAXException, IOException, ParserConfigurationException {
        SAXParser parser = XmlToolkit.createSAXParserFactory().newSAXParser();
        parser.parse(new InputSource(reader), (DefaultHandler)new StateHandler(state));
    }

    public static IState fromXMLString(String document) throws SAXException {
        return new StateElement(XmlToolkit.loadDocumentFromString(document).getDocumentElement());
    }

    public static IStateful statefulFromXMLString(final String document) {
        return new IStateful(){

            @Override
            public void saveTo(IWritableState state) {
                try {
                    StateToolkit.saveXMLDocumentTo(new StringReader(document), state);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read state from XML string", e);
                }
            }
        };
    }

    public static IStateful statefulFromXMLFile(final File document, final Charset charset) {
        return new IStateful(){

            @Override
            public void saveTo(IWritableState state) {
                try (FileInputStream fis = new FileInputStream(document);){
                    StateToolkit.saveXMLDocumentTo(new InputStreamReader((InputStream)fis, charset), state);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read state from XML string", e);
                }
            }
        };
    }

    public static IState fromXMLFile(File document) throws SAXException, IOException {
        return new StateElement(XmlToolkit.loadDocumentFromFile(document).getDocumentElement());
    }

    public static IWritableState createWriter(String rootName) throws IOException {
        return new StateElementWriter(rootName);
    }

    public static String toXMLString(IStateful state) {
        try {
            StringWriter wrt = new StringWriter();
            StateToolkit.writeAsXml(state, wrt);
            return wrt.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeAsXml(IStateful state, Writer writer) throws IOException {
        StateElementWriter stateWriter = new StateElementWriter("state");
        state.saveTo(stateWriter);
        stateWriter.write(writer);
    }

    public static void writeBoolean(IWritableState state, String attribute, Boolean value) {
        if (value != null) {
            state.putString(attribute, Boolean.toString(value));
        }
    }

    public static Boolean readBoolean(IState state, String attribute, Boolean defaultValue) {
        if (state == null) {
            return defaultValue;
        }
        String v = state.getAttribute(attribute);
        if (v == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(v)) {
            return true;
        }
        if ("false".equalsIgnoreCase(v)) {
            return false;
        }
        return defaultValue;
    }

    public static void writeFloat(IWritableState state, String attribute, Float value) {
        if (value != null) {
            state.putString(attribute, Float.toString(value.floatValue()));
        }
    }

    public static Float readFloat(IState state, String attribute, Float defaultValue) {
        if (state == null) {
            return defaultValue;
        }
        String v = state.getAttribute(attribute);
        if (v != null) {
            try {
                return Float.valueOf(Float.parseFloat(v));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void writeInt(IWritableState state, String attribute, Integer value) {
        if (value != null) {
            state.putString(attribute, Integer.toString(value));
        }
    }

    public static Integer readInt(IState state, String attribute, Integer defaultValue) {
        if (state == null) {
            return defaultValue;
        }
        String v = state.getAttribute(attribute);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static <T extends Enum<T>> void writeEnum(IWritableState state, String attribute, T value) {
        if (value != null) {
            state.putString(attribute, value.name());
        }
    }

    public static <T extends Enum<T>> T readEnum(IState state, String attribute, T defaultValue, Class<T> klass) {
        if (state == null) {
            return defaultValue;
        }
        String v = state.getAttribute(attribute);
        try {
            return v == null ? defaultValue : Enum.valueOf(klass, v);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private static class StateHandler
    extends DefaultHandler {
        private final IWritableState documentElement;
        private final Deque<IWritableState> stateStack = new LinkedList<IWritableState>();

        public StateHandler(IWritableState state) {
            this.documentElement = state;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            IWritableState state = this.stateStack.isEmpty() ? this.documentElement : this.stateStack.peek().createChild(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                state.putString(attributes.getQName(i), attributes.getValue(i));
            }
            this.stateStack.push(state);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.stateStack.pop();
        }
    }
}

