/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class EventAppearance {
    private static final Logger LOGGER = Logger.getLogger("org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal");
    private static final Pattern PATH_SPLIT_REGEX = Pattern.compile("\\/");
    private static final Map<String, String> HUMAN_NAMES;

    private static Properties loadProperties(String fileName) {
        Properties properties = new Properties();
        try (InputStream in = EventAppearance.class.getResourceAsStream(fileName);){
            if (in != null) {
                properties.load(in);
            } else {
                LOGGER.severe("Couldn't find file '" + fileName + "'");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Problem loading file '" + fileName + "'", e);
        }
        return properties;
    }

    public static String[] getHumanSegmentArray(String path) {
        String[] pathArray = PATH_SPLIT_REGEX.split(path);
        for (int i = 0; i < pathArray.length; ++i) {
            pathArray[i] = EventAppearance.getHumanSegmentName(pathArray[i].trim());
        }
        return pathArray;
    }

    private static String getHumanSegmentName(String path) {
        String humanName = HUMAN_NAMES.get(path = path.toLowerCase(Locale.ENGLISH));
        if (humanName != null) {
            return humanName;
        }
        return EventAppearance.humanifyName(path);
    }

    public static String humanifyName(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.length() == 0) {
            return "<Empty>";
        }
        StringBuilder humanReadable = new StringBuilder(identifier.length());
        boolean firstLetter = true;
        for (int n = 0; n < identifier.length(); ++n) {
            char c = identifier.charAt(n);
            if (c == '_') {
                c = ' ';
            }
            if (firstLetter && Character.isLetter(c)) {
                humanReadable.append(Character.toUpperCase(c));
            } else {
                humanReadable.append(c);
            }
            firstLetter = c == ' ';
        }
        return humanReadable.toString();
    }

    static {
        Properties props = EventAppearance.loadProperties("segments.properties");
        HashMap<String, String> segments = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            segments.put(key.toLowerCase(Locale.ENGLISH), (String)entry.getValue());
        }
        HUMAN_NAMES = Collections.unmodifiableMap(segments);
    }
}

