/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.io.UnsupportedEncodingException;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.UnitLookup;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.IArrayElementParser;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;

final class UTFStringParser
implements IArrayElementParser<String>,
IValueReader {
    private static final String CHARSET = "UTF-8";
    public static final UTFStringParser INSTANCE = new UTFStringParser();

    UTFStringParser() {
    }

    @Override
    public Object readValue(byte[] bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        return UTFStringParser.readString(bytes, offset);
    }

    @Override
    public String readElement(byte[] bytes, Offset offset) throws InvalidJfrFileException {
        return UTFStringParser.readString(bytes, offset);
    }

    public static String readString(byte[] bytes, Offset offset) throws InvalidJfrFileException {
        int len = UTFStringParser.readUnsignedShort(bytes, offset.get());
        offset.increase(2);
        int index = offset.get();
        offset.increase(len);
        try {
            return new String(bytes, index, len, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static int readUnsignedShort(byte[] bytes, int offset) {
        int ch1 = bytes[offset] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        return (ch1 << 8) + (ch2 << 0);
    }

    public String[] createArray(int length) {
        return new String[length];
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.PLAIN_TEXT;
    }
}

