/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.factories;

import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCOldObject;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.UnitLookup;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.util.MCOldObject;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;

public class OldObjectFactory
implements IPoolFactory<IMCOldObject> {
    private final int addressIndex;
    private final int typeIndex;
    private final int objectDescriptionIndex;
    private final int referrerIndex;
    private final int fieldNameIndex;
    private final int fieldModifierIndex;
    private final int arraySizeIndex;
    private final int arrayIndexIndex;

    public OldObjectFactory(ValueDescriptor[] descriptors) {
        this.addressIndex = ValueDescriptor.getIndex(descriptors, "address");
        this.typeIndex = ValueDescriptor.getIndex(descriptors, "objectClass");
        this.objectDescriptionIndex = ValueDescriptor.getIndex(descriptors, "objectDescription");
        this.referrerIndex = ValueDescriptor.getIndex(descriptors, "referrer");
        this.fieldNameIndex = ValueDescriptor.getIndex(descriptors, "fieldName");
        this.fieldModifierIndex = ValueDescriptor.getIndex(descriptors, "fieldModifier");
        this.arraySizeIndex = ValueDescriptor.getIndex(descriptors, "arraySize");
        this.arrayIndexIndex = ValueDescriptor.getIndex(descriptors, "arrayIndex");
    }

    @Override
    public IMCOldObject createObject(long identifier, Object source) {
        Object[] o = (Object[])source;
        if (o != null) {
            IQuantity address = null;
            IMCType type = null;
            String objectDescription = null;
            IMCOldObject referrer = null;
            String fieldName = null;
            IQuantity fieldModifier = null;
            IQuantity arraySize = null;
            IQuantity arrayIndex = null;
            if (this.addressIndex != -1) {
                address = (IQuantity)o[this.addressIndex];
            }
            if (this.typeIndex != -1) {
                type = (IMCType)o[this.typeIndex];
            }
            if (this.objectDescriptionIndex != -1) {
                objectDescription = (String)o[this.objectDescriptionIndex];
            }
            if (this.referrerIndex != -1) {
                referrer = (IMCOldObject)o[this.referrerIndex];
            }
            if (this.fieldNameIndex != -1) {
                fieldName = (String)o[this.fieldNameIndex];
            }
            if (this.fieldModifierIndex != -1) {
                fieldModifier = (IQuantity)o[this.fieldModifierIndex];
            }
            if (this.arraySizeIndex != -1) {
                arraySize = (IQuantity)o[this.arraySizeIndex];
            }
            if (this.arrayIndexIndex != -1) {
                arrayIndex = (IQuantity)o[this.arrayIndexIndex];
            }
            return new MCOldObject(address, type, objectDescription, referrer, fieldName, fieldModifier, arraySize, arrayIndex);
        }
        return null;
    }

    @Override
    public ContentType<IMCOldObject> getContentType() {
        return UnitLookup.OLD_OBJECT;
    }
}

