/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v1;

import java.io.IOException;
import java.util.logging.Logger;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v1.IDataInput;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v1.StructTypes;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v1.ValueReaders;

public class SpecificReaders {
    private static Logger LOG = Logger.getLogger(SpecificReaders.class.getName());

    static class StackFrame2Reader
    extends ValueReaders.ReflectiveReader {
        boolean fallback;
        int methodIdx;
        int lineNumberIdx;
        int bytecodeIndexIdx;
        int typeIdx;

        <T> StackFrame2Reader(Class<T> klass, int fieldCount, ContentType<? super T> ct) {
            super(klass, fieldCount, ct);
        }

        @Override
        void addField(String identifier, String name, String description, ValueReaders.IValueReader reader) throws InvalidJfrFileException {
            super.addField(identifier, name, description, reader);
            int currentIdx = this.valueReaders.size() - 1;
            switch (identifier) {
                case "method": {
                    this.methodIdx = currentIdx;
                    break;
                }
                case "lineNumber": {
                    this.lineNumberIdx = currentIdx;
                    break;
                }
                case "bytecodeIndex": {
                    this.bytecodeIndexIdx = currentIdx;
                    break;
                }
                case "type": {
                    this.typeIdx = currentIdx;
                    break;
                }
                default: {
                    this.fallback = true;
                    LOG.warning("unexpected fields for StackFrame2Reader: " + identifier);
                }
            }
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            if (this.fallback) {
                return super.read(in, allowUnresolvedReference);
            }
            StructTypes.JfrFrame jfrFrame = new StructTypes.JfrFrame();
            jfrFrame.method = ((ValueReaders.IValueReader)this.valueReaders.get(this.methodIdx)).read(in, allowUnresolvedReference);
            jfrFrame.lineNumber = ((ValueReaders.IValueReader)this.valueReaders.get(this.lineNumberIdx)).read(in, allowUnresolvedReference);
            jfrFrame.bytecodeIndex = ((ValueReaders.IValueReader)this.valueReaders.get(this.bytecodeIndexIdx)).read(in, allowUnresolvedReference);
            jfrFrame.type = ((ValueReaders.IValueReader)this.valueReaders.get(this.typeIdx)).read(in, allowUnresolvedReference);
            return jfrFrame;
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            if (!(value instanceof StructTypes.JfrFrame)) {
                throw new RuntimeException("Invalid object type, expected JfrFrame");
            }
            StructTypes.JfrFrame jfrFrame = (StructTypes.JfrFrame)value;
            jfrFrame.method = ((ValueReaders.IValueReader)this.valueReaders.get(0)).resolve(jfrFrame.method);
            jfrFrame.lineNumber = ((ValueReaders.IValueReader)this.valueReaders.get(1)).resolve(jfrFrame.lineNumber);
            jfrFrame.bytecodeIndex = ((ValueReaders.IValueReader)this.valueReaders.get(2)).resolve(jfrFrame.bytecodeIndex);
            jfrFrame.type = ((ValueReaders.IValueReader)this.valueReaders.get(3)).resolve(jfrFrame.type);
            return value;
        }
    }
}

