/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.jdk;

import java.util.function.Predicate;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCFrame;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCMethod;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCStackTrace;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItem;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItemFilter;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IMemberAccessor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.ItemFilters;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.util.PredicateToolkit;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;

public final class JdkFilters {
    public static final IItemFilter SOCKET_READ = ItemFilters.type("jdk.SocketRead");
    public static final IItemFilter SOCKET_WRITE = ItemFilters.type("jdk.SocketWrite");
    public static final IItemFilter SOCKET_READ_OR_WRITE = ItemFilters.or(SOCKET_READ, SOCKET_WRITE);
    public static final IItemFilter NO_RMI_SOCKET_READ = ItemFilters.and(SOCKET_READ, ItemFilters.not(new MethodFilter("sun.rmi.transport.tcp.TCPTransport", "handleMessages")), ItemFilters.not(new MethodFilter("javax.management.remote.rmi.RMIConnector$RMINotifClient", "fetchNotifs")));
    public static final IItemFilter NO_RMI_SOCKET_WRITE = ItemFilters.and(SOCKET_WRITE, ItemFilters.not(new MethodFilter("sun.rmi.transport.tcp.TCPTransport$ConnectionHandler", "run")), ItemFilters.not(new MethodFilter("sun.rmi.transport.tcp.TCPTransport$ConnectionHandler", "run0")));
    public static final IItemFilter ENVIRONMENT_VARIABLE = ItemFilters.type("jdk.InitialEnvironmentVariable");
    public static final IItemFilter FILE_READ = ItemFilters.type("jdk.FileRead");
    public static final IItemFilter FILE_WRITE = ItemFilters.type("jdk.FileWrite");
    public static final IItemFilter CODE_CACHE_FULL = ItemFilters.type("jdk.CodeCacheFull");
    public static final IItemFilter CODE_CACHE_STATISTICS = ItemFilters.type("jdk.CodeCacheStatistics");
    public static final IItemFilter CODE_CACHE_CONFIGURATION = ItemFilters.type("jdk.CodeCacheConfiguration");
    public static final IItemFilter SWEEP_CODE_CACHE = ItemFilters.type("jdk.SweepCodeCache");
    public static final IItemFilter CODE_CACHE = ItemFilters.or(CODE_CACHE_FULL, CODE_CACHE_STATISTICS, SWEEP_CODE_CACHE, CODE_CACHE_CONFIGURATION);
    public static final IItemFilter CPU_INFORMATION = ItemFilters.type("jdk.CPUInformation");
    public static final IItemFilter GC_CONFIG = ItemFilters.type("jdk.GCConfiguration");
    public static final IItemFilter HEAP_CONFIG = ItemFilters.type("jdk.GCHeapConfiguration");
    public static final IItemFilter BEFORE_GC = ItemFilters.equals(JdkAttributes.GC_WHEN, "Before GC");
    public static final IItemFilter AFTER_GC = ItemFilters.equals(JdkAttributes.GC_WHEN, "After GC");
    public static final IItemFilter ALLOC_OUTSIDE_TLAB = ItemFilters.type("jdk.ObjectAllocationOutsideTLAB");
    public static final IItemFilter ALLOC_INSIDE_TLAB = ItemFilters.type("jdk.ObjectAllocationInNewTLAB");
    public static final IItemFilter ALLOC_ALL = ItemFilters.type("jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB");
    public static final IItemFilter OBJ_ALLOC = ItemFilters.type("jdk.ObjectAllocationSample");
    public static final IItemFilter REFERENCE_STATISTICS = ItemFilters.type("jdk.GCReferenceStatistics");
    public static final IItemFilter GARBAGE_COLLECTION = ItemFilters.type("jdk.GarbageCollection");
    public static final IItemFilter OLD_GARBAGE_COLLECTION = ItemFilters.type("jdk.OldGarbageCollection");
    public static final IItemFilter YOUNG_GARBAGE_COLLECTION = ItemFilters.type("jdk.YoungGarbageCollection");
    public static final IItemFilter CONCURRENT_MODE_FAILURE = ItemFilters.type("jdk.ConcurrentModeFailure");
    public static final IItemFilter ERRORS = ItemFilters.type("jdk.JavaErrorThrow");
    public static final IItemFilter EXCEPTIONS = ItemFilters.type("jdk.JavaExceptionThrow");
    public static final IItemFilter THROWABLES = ItemFilters.or(EXCEPTIONS, ERRORS);
    public static final IItemFilter THROWABLES_STATISTICS = ItemFilters.type("jdk.ExceptionStatistics");
    public static final IItemFilter CLASS_UNLOAD = ItemFilters.type("jdk.ClassUnload");
    public static final IItemFilter CLASS_LOAD_STATISTICS = ItemFilters.type("jdk.ClassLoadingStatistics");
    public static final IItemFilter CLASS_LOADER_STATISTICS = ItemFilters.type("jdk.ClassLoaderStatistics");
    public static final IItemFilter CLASS_LOAD = ItemFilters.type("jdk.ClassLoad");
    public static final IItemFilter CLASS_LOAD_OR_UNLOAD = ItemFilters.or(CLASS_LOAD, CLASS_UNLOAD);
    public static final IItemFilter CLASS_DEFINE = ItemFilters.type("jdk.ClassDefine");
    public static final IItemFilter CLASS_LOADER_EVENTS = ItemFilters.or(CLASS_LOAD, CLASS_UNLOAD, CLASS_DEFINE, CLASS_LOADER_STATISTICS);
    public static final IItemFilter MONITOR_ENTER = ItemFilters.type("jdk.JavaMonitorEnter");
    public static final IItemFilter FILE_OR_SOCKET_IO = ItemFilters.type("jdk.SocketRead", "jdk.SocketWrite", "jdk.FileRead", "jdk.FileWrite");
    public static final IItemFilter THREAD_LATENCIES = ItemFilters.type("jdk.JavaMonitorEnter", "jdk.JavaMonitorWait", "jdk.ThreadSleep", "jdk.ThreadPark", "jdk.SocketRead", "jdk.SocketWrite", "jdk.FileRead", "jdk.FileWrite", "jdk.ClassLoad", "jdk.Compilation", "jdk.ExecutionSampling");
    public static final IItemFilter EXECUTION_SAMPLE = ItemFilters.type("jdk.ExecutionSample");
    public static final IItemFilter CONTEXT_SWITCH_RATE = ItemFilters.type("jdk.ThreadContextSwitchRate");
    public static final IItemFilter CPU_LOAD = ItemFilters.type("jdk.CPULoad");
    public static final IItemFilter GC_PAUSE = ItemFilters.type("jdk.GCPhasePause");
    public static final IItemFilter GC_PAUSE_PHASE = ItemFilters.type("jdk.GCPhasePauseLevel1", "jdk.GCPhasePauseLevel2", "jdk.GCPhasePauseLevel3", "jdk.GCPhasePauseLevel4");
    public static final IItemFilter TIME_CONVERSION = ItemFilters.type("jdk.CPUTimeStampCounter");
    public static final IItemFilter VM_INFO = ItemFilters.type("jdk.JVMInformation");
    public static final IItemFilter THREAD_DUMP = ItemFilters.type("jdk.ThreadDump");
    public static final IItemFilter SYSTEM_PROPERTIES = ItemFilters.type("jdk.InitialSystemProperty");
    public static final IItemFilter JFR_DATA_LOST = ItemFilters.type("jdk.DataLoss");
    public static final IItemFilter PROCESSES = ItemFilters.type("jdk.SystemProcess");
    public static final IItemFilter OBJECT_COUNT = ItemFilters.type("jdk.ObjectCount");
    public static final IItemFilter METASPACE_OOM = ItemFilters.type("jdk.MetaspaceOOM");
    public static final IItemFilter COMPILATION = ItemFilters.type("jdk.Compilation");
    public static final IItemFilter COMPILER_FAILURE = ItemFilters.type("jdk.CompilationFailure");
    public static final IItemFilter COMPILER_STATS = ItemFilters.type("jdk.CompilerStatistics");
    public static final IItemFilter OS_MEMORY_SUMMARY = ItemFilters.type("jdk.PhysicalMemory");
    public static final IItemFilter HEAP_SUMMARY = ItemFilters.type("jdk.GCHeapSummary");
    public static final IItemFilter HEAP_SUMMARY_BEFORE_GC = ItemFilters.and(HEAP_SUMMARY, BEFORE_GC);
    public static final IItemFilter HEAP_SUMMARY_AFTER_GC = ItemFilters.and(HEAP_SUMMARY, AFTER_GC);
    public static final IItemFilter METASPACE_SUMMARY = ItemFilters.type("jdk.MetaspaceSummary");
    public static final IItemFilter METASPACE_SUMMARY_AFTER_GC = ItemFilters.and(METASPACE_SUMMARY, AFTER_GC);
    public static final IItemFilter RECORDINGS = ItemFilters.type("jdk.ActiveRecording");
    public static final IItemFilter RECORDING_SETTING = ItemFilters.type("jdk.ActiveSetting");
    public static final IItemFilter SAFE_POINTS = ItemFilters.type("jdk.SafepointBegin", "jdk.SafepointCleanup", "jdk.SafepointCleanupTask", "jdk.SafepointStateSynchronization", "jdk.SafepointWaitBlocked", "jdk.SafepointEnd");
    public static final IItemFilter VM_OPERATIONS = ItemFilters.type("jdk.ExecuteVMOperation");
    public static final IItemFilter VM_OPERATIONS_BLOCKING_OR_SAFEPOINT = ItemFilters.and(ItemFilters.type("jdk.ExecuteVMOperation"), ItemFilters.or(ItemFilters.equals(JdkAttributes.BLOCKING, true), ItemFilters.equals(JdkAttributes.SAFEPOINT, true)));
    public static final IItemFilter VM_OPERATIONS_SAFEPOINT = ItemFilters.and(ItemFilters.type("jdk.ExecuteVMOperation"), ItemFilters.equals(JdkAttributes.SAFEPOINT, true));
    public static final IItemFilter APPLICATION_PAUSES = ItemFilters.or(GC_PAUSE, SAFE_POINTS, VM_OPERATIONS_SAFEPOINT);
    public static final IItemFilter BIASED_LOCKING_REVOCATIONS = ItemFilters.type("jdk.BiasedLockClassRevocation", "jdk.BiasedLockRevocation", "jdk.BiasedLockSelfRevocation");
    public static final IItemFilter THREAD_CPU_LOAD = ItemFilters.type("jdk.ThreadCPULoad");
    public static final IItemFilter NATIVE_METHOD_SAMPLE = ItemFilters.type("jdk.NativeMethodSample");
    public static final IItemFilter THREAD_START = ItemFilters.type("jdk.ThreadStart");
    public static final IItemFilter THREAD_END = ItemFilters.type("jdk.ThreadEnd");

    public static class MethodFilter
    implements IItemFilter {
        private final String typeName;
        private final String methodName;

        public MethodFilter(String typeName, String methodName) {
            this.typeName = typeName;
            this.methodName = methodName;
        }

        @Override
        public Predicate<IItem> getPredicate(IType<IItem> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            if (accessor == null) {
                return PredicateToolkit.falsePredicate();
            }
            return new Predicate<IItem>(){

                @Override
                public boolean test(IItem o) {
                    IMCStackTrace st = (IMCStackTrace)accessor.getMember(o);
                    if (st != null) {
                        for (IMCFrame iMCFrame : st.getFrames()) {
                            IMCMethod method = iMCFrame.getMethod();
                            if (!typeName.equals(method.getType().getFullName()) || !methodName.equals(method.getMethodName())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
        }
    }
}

