/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.core.env.ConfigurableEnvironment;
import org.qubership.profiler.shaded.org.springframework.core.env.MutablePropertySources;
import org.qubership.profiler.shaded.org.springframework.core.env.PropertySource;
import org.qubership.profiler.shaded.org.springframework.core.env.StandardEnvironment;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

final class EnvironmentConverter {
    private static final String CONFIGURABLE_WEB_ENVIRONMENT_CLASS = "org.qubership.profiler.shaded.org.springframework.web.context.ConfigurableWebEnvironment";
    private static final Set<String> SERVLET_ENVIRONMENT_SOURCE_NAMES;
    private final ClassLoader classLoader;

    EnvironmentConverter(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    StandardEnvironment convertToStandardEnvironmentIfNecessary(ConfigurableEnvironment environment) {
        if (environment instanceof StandardEnvironment && !this.isWebEnvironment(environment, this.classLoader)) {
            return (StandardEnvironment)environment;
        }
        return this.convertToStandardEnvironment(environment);
    }

    private boolean isWebEnvironment(ConfigurableEnvironment environment, ClassLoader classLoader) {
        try {
            Class<?> webEnvironmentClass = ClassUtils.forName(CONFIGURABLE_WEB_ENVIRONMENT_CLASS, classLoader);
            return webEnvironmentClass.isInstance(environment);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private StandardEnvironment convertToStandardEnvironment(ConfigurableEnvironment environment) {
        StandardEnvironment result = new StandardEnvironment();
        result.setActiveProfiles(environment.getActiveProfiles());
        result.setConversionService(environment.getConversionService());
        this.copyNonServletPropertySources(environment, result);
        return result;
    }

    private void copyNonServletPropertySources(ConfigurableEnvironment source, StandardEnvironment target) {
        this.removeAllPropertySources(target.getPropertySources());
        for (PropertySource<?> propertySource : source.getPropertySources()) {
            if (SERVLET_ENVIRONMENT_SOURCE_NAMES.contains(propertySource.getName())) continue;
            target.getPropertySources().addLast(propertySource);
        }
    }

    private void removeAllPropertySources(MutablePropertySources propertySources) {
        HashSet<String> names = new HashSet<String>();
        for (PropertySource<?> propertySource : propertySources) {
            names.add(propertySource.getName());
        }
        for (String name : names) {
            propertySources.remove(name);
        }
    }

    static {
        HashSet<String> names = new HashSet<String>();
        names.add("servletContextInitParams");
        names.add("servletConfigInitParams");
        names.add("jndiProperties");
        SERVLET_ENVIRONMENT_SOURCE_NAMES = Collections.unmodifiableSet(names);
    }
}

