/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot;

import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.boot.Banner;
import org.qubership.profiler.shaded.org.springframework.boot.SpringBootVersion;
import org.qubership.profiler.shaded.org.springframework.boot.ansi.AnsiPropertySource;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.core.env.MapPropertySource;
import org.qubership.profiler.shaded.org.springframework.core.env.MutablePropertySources;
import org.qubership.profiler.shaded.org.springframework.core.env.PropertyResolver;
import org.qubership.profiler.shaded.org.springframework.core.env.PropertySourcesPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.core.io.Resource;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.StreamUtils;

public class ResourceBanner
implements Banner {
    private static final Log logger = LogFactory.getLog(ResourceBanner.class);
    private Resource resource;

    public ResourceBanner(Resource resource) {
        Assert.notNull(resource, "Resource must not be null");
        Assert.isTrue(resource.exists(), "Resource must exist");
        this.resource = resource;
    }

    @Override
    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        try {
            String banner = StreamUtils.copyToString(this.resource.getInputStream(), environment.getProperty("banner.charset", Charset.class, Charset.forName("UTF-8")));
            for (PropertyResolver resolver : this.getPropertyResolvers(environment, sourceClass)) {
                banner = resolver.resolvePlaceholders(banner);
            }
            out.println(banner);
        }
        catch (Exception ex) {
            logger.warn("Banner not printable: " + this.resource + " (" + ex.getClass() + ": '" + ex.getMessage() + "')", ex);
        }
    }

    protected List<PropertyResolver> getPropertyResolvers(Environment environment, Class<?> sourceClass) {
        ArrayList<PropertyResolver> resolvers = new ArrayList<PropertyResolver>();
        resolvers.add(environment);
        resolvers.add(this.getVersionResolver(sourceClass));
        resolvers.add(this.getAnsiResolver());
        resolvers.add(this.getTitleResolver(sourceClass));
        return resolvers;
    }

    private PropertyResolver getVersionResolver(Class<?> sourceClass) {
        MutablePropertySources propertySources = new MutablePropertySources();
        propertySources.addLast(new MapPropertySource("version", this.getVersionsMap(sourceClass)));
        return new PropertySourcesPropertyResolver(propertySources);
    }

    private Map<String, Object> getVersionsMap(Class<?> sourceClass) {
        String appVersion = this.getApplicationVersion(sourceClass);
        String bootVersion = this.getBootVersion();
        HashMap<String, Object> versions = new HashMap<String, Object>();
        versions.put("application.version", this.getVersionString(appVersion, false));
        versions.put("spring-boot.version", this.getVersionString(bootVersion, false));
        versions.put("application.formatted-version", this.getVersionString(appVersion, true));
        versions.put("spring-boot.formatted-version", this.getVersionString(bootVersion, true));
        return versions;
    }

    protected String getApplicationVersion(Class<?> sourceClass) {
        Package sourcePackage = sourceClass != null ? sourceClass.getPackage() : null;
        return sourcePackage != null ? sourcePackage.getImplementationVersion() : null;
    }

    protected String getBootVersion() {
        return SpringBootVersion.getVersion();
    }

    private String getVersionString(String version, boolean format) {
        if (version == null) {
            return "";
        }
        return format ? " (v" + version + ")" : version;
    }

    private PropertyResolver getAnsiResolver() {
        MutablePropertySources sources = new MutablePropertySources();
        sources.addFirst(new AnsiPropertySource("ansi", true));
        return new PropertySourcesPropertyResolver(sources);
    }

    private PropertyResolver getTitleResolver(Class<?> sourceClass) {
        MutablePropertySources sources = new MutablePropertySources();
        String applicationTitle = this.getApplicationTitle(sourceClass);
        Map<String, Object> titleMap = Collections.singletonMap("application.title", applicationTitle != null ? applicationTitle : "");
        sources.addFirst(new MapPropertySource("title", titleMap));
        return new PropertySourcesPropertyResolver(sources);
    }

    protected String getApplicationTitle(Class<?> sourceClass) {
        Package sourcePackage = sourceClass != null ? sourceClass.getPackage() : null;
        return sourcePackage != null ? sourcePackage.getImplementationTitle() : null;
    }
}

