/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.validation.Validation;
import org.qubership.profiler.shaded.org.apache.catalina.mbeans.MBeanFactory;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.ApplicationFailedEvent;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.ApplicationReadyEvent;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.SpringApplicationEvent;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationListener;
import org.qubership.profiler.shaded.org.springframework.core.annotation.Order;
import org.qubership.profiler.shaded.org.springframework.format.support.DefaultFormattingConversionService;
import org.qubership.profiler.shaded.org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.qubership.profiler.shaded.org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;

@Order(value=-2147483627)
public class BackgroundPreinitializer
implements ApplicationListener<SpringApplicationEvent> {
    private static final AtomicBoolean preinitializationStarted = new AtomicBoolean(false);
    private static final CountDownLatch preinitializationComplete = new CountDownLatch(1);

    @Override
    public void onApplicationEvent(SpringApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent && preinitializationStarted.compareAndSet(false, true)) {
            this.performPreinitialization();
        }
        if ((event instanceof ApplicationReadyEvent || event instanceof ApplicationFailedEvent) && preinitializationStarted.get()) {
            try {
                preinitializationComplete.await();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void performPreinitialization() {
        try {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    this.runSafely(new MessageConverterInitializer());
                    this.runSafely(new MBeanFactoryInitializer());
                    this.runSafely(new ValidationInitializer());
                    this.runSafely(new JacksonInitializer());
                    this.runSafely(new ConversionServiceInitializer());
                    preinitializationComplete.countDown();
                }

                public void runSafely(Runnable runnable) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }, "background-preinit");
            thread.start();
        }
        catch (Exception ex) {
            preinitializationComplete.countDown();
        }
    }

    private static class ConversionServiceInitializer
    implements Runnable {
        private ConversionServiceInitializer() {
        }

        @Override
        public void run() {
            new DefaultFormattingConversionService();
        }
    }

    private static class JacksonInitializer
    implements Runnable {
        private JacksonInitializer() {
        }

        @Override
        public void run() {
            Jackson2ObjectMapperBuilder.json().build();
        }
    }

    private static class ValidationInitializer
    implements Runnable {
        private ValidationInitializer() {
        }

        @Override
        public void run() {
            Validation.byDefaultProvider().configure();
        }
    }

    private static class MBeanFactoryInitializer
    implements Runnable {
        private MBeanFactoryInitializer() {
        }

        @Override
        public void run() {
            new MBeanFactory();
        }
    }

    private static class MessageConverterInitializer
    implements Runnable {
        private MessageConverterInitializer() {
        }

        @Override
        public void run() {
            new AllEncompassingFormHttpMessageConverter();
        }
    }
}

