/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.amqp;

import org.qubership.profiler.shaded.org.aopalliance.aop.Advice;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.qubership.profiler.shaded.org.springframework.amqp.support.converter.MessageConverter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public final class SimpleRabbitListenerContainerFactoryConfigurer {
    private MessageConverter messageConverter;
    private MessageRecoverer messageRecoverer;
    private RabbitProperties rabbitProperties;

    void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setMessageRecoverer(MessageRecoverer messageRecoverer) {
        this.messageRecoverer = messageRecoverer;
    }

    void setRabbitProperties(RabbitProperties rabbitProperties) {
        this.rabbitProperties = rabbitProperties;
    }

    public void configure(SimpleRabbitListenerContainerFactory factory, ConnectionFactory connectionFactory) {
        RabbitProperties.ListenerRetry retryConfig;
        Assert.notNull(factory, "Factory must not be null");
        Assert.notNull(connectionFactory, "ConnectionFactory must not be null");
        factory.setConnectionFactory(connectionFactory);
        if (this.messageConverter != null) {
            factory.setMessageConverter(this.messageConverter);
        }
        RabbitProperties.AmqpContainer config = this.rabbitProperties.getListener().getSimple();
        factory.setAutoStartup(Boolean.valueOf(config.isAutoStartup()));
        if (config.getAcknowledgeMode() != null) {
            factory.setAcknowledgeMode(config.getAcknowledgeMode());
        }
        if (config.getConcurrency() != null) {
            factory.setConcurrentConsumers(config.getConcurrency());
        }
        if (config.getMaxConcurrency() != null) {
            factory.setMaxConcurrentConsumers(config.getMaxConcurrency());
        }
        if (config.getPrefetch() != null) {
            factory.setPrefetchCount(config.getPrefetch());
        }
        if (config.getTransactionSize() != null) {
            factory.setTxSize(config.getTransactionSize());
        }
        if (config.getDefaultRequeueRejected() != null) {
            factory.setDefaultRequeueRejected(config.getDefaultRequeueRejected());
        }
        if (config.getIdleEventInterval() != null) {
            factory.setIdleEventInterval(config.getIdleEventInterval());
        }
        if ((retryConfig = config.getRetry()).isEnabled()) {
            RetryInterceptorBuilder.StatelessRetryInterceptorBuilder builder = retryConfig.isStateless() ? RetryInterceptorBuilder.stateless() : RetryInterceptorBuilder.stateful();
            builder.maxAttempts(retryConfig.getMaxAttempts());
            builder.backOffOptions(retryConfig.getInitialInterval(), retryConfig.getMultiplier(), retryConfig.getMaxInterval());
            MessageRecoverer recoverer = this.messageRecoverer != null ? this.messageRecoverer : new RejectAndDontRequeueRecoverer();
            builder.recoverer(recoverer);
            factory.setAdviceChain(new Advice[]{builder.build()});
        }
    }
}

