/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache;

import java.util.Locale;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheConfigurations;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheType;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.qubership.profiler.shaded.org.springframework.boot.bind.RelaxedPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConditionContext;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotatedTypeMetadata;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.core.type.ClassMetadata;

class CacheCondition
extends SpringBootCondition {
    CacheCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String sourceClass = "";
        if (metadata instanceof ClassMetadata) {
            sourceClass = ((ClassMetadata)((Object)metadata)).getClassName();
        }
        ConditionMessage.Builder message = ConditionMessage.forCondition("Cache", sourceClass);
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(context.getEnvironment(), "spring.cache.");
        if (!resolver.containsProperty("type")) {
            return ConditionOutcome.match(message.because("automatic cache type"));
        }
        CacheType cacheType = CacheConfigurations.getType(((AnnotationMetadata)metadata).getClassName());
        String value = resolver.getProperty("type").replace('-', '_').toUpperCase(Locale.ENGLISH);
        if (value.equals(cacheType.name())) {
            return ConditionOutcome.match(message.because(value + " cache type"));
        }
        return ConditionOutcome.noMatch(message.because(value + " cache type"));
    }
}

