/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hateoas;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.hateoas.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.qubership.profiler.shaded.org.springframework.http.MediaType;
import org.qubership.profiler.shaded.org.springframework.http.converter.AbstractHttpMessageConverter;
import org.qubership.profiler.shaded.org.springframework.http.converter.HttpMessageConverter;
import org.qubership.profiler.shaded.org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
public class HypermediaHttpMessageConverterConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.hateoas", name={"use-hal-as-default-json-media-type"}, matchIfMissing=true)
    public static HalMessageConverterSupportedMediaTypesCustomizer halMessageConverterSupportedMediaTypeCustomizer() {
        return new HalMessageConverterSupportedMediaTypesCustomizer();
    }

    private static class HalMessageConverterSupportedMediaTypesCustomizer
    implements BeanFactoryAware {
        private volatile BeanFactory beanFactory;

        private HalMessageConverterSupportedMediaTypesCustomizer() {
        }

        @PostConstruct
        public void configureHttpMessageConverters() {
            if (this.beanFactory instanceof ListableBeanFactory) {
                this.configureHttpMessageConverters(((ListableBeanFactory)this.beanFactory).getBeansOfType(RequestMappingHandlerAdapter.class).values());
            }
        }

        private void configureHttpMessageConverters(Collection<RequestMappingHandlerAdapter> handlerAdapters) {
            for (RequestMappingHandlerAdapter handlerAdapter : handlerAdapters) {
                for (HttpMessageConverter messageConverter : handlerAdapter.getMessageConverters()) {
                    this.configureHttpMessageConverter(messageConverter);
                }
            }
        }

        private void configureHttpMessageConverter(HttpMessageConverter<?> converter) {
            if (converter instanceof TypeConstrainedMappingJackson2HttpMessageConverter) {
                ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>(converter.getSupportedMediaTypes());
                if (!supportedMediaTypes.contains(MediaType.APPLICATION_JSON)) {
                    supportedMediaTypes.add(MediaType.APPLICATION_JSON);
                }
                ((AbstractHttpMessageConverter)converter).setSupportedMediaTypes(supportedMediaTypes);
            }
        }

        @Override
        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

