/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConfigurationCondition;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

@Configuration
@ConditionalOnClass(value={HazelcastInstance.class, LocalContainerEntityManagerFactoryBean.class})
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class HazelcastJpaDependencyAutoConfiguration {
    @Bean
    @Conditional(value={OnHazelcastAndJpaCondition.class})
    public static HazelcastInstanceJpaDependencyPostProcessor hazelcastInstanceJpaDependencyPostProcessor() {
        return new HazelcastInstanceJpaDependencyPostProcessor();
    }

    static class OnHazelcastAndJpaCondition
    extends AllNestedConditions {
        OnHazelcastAndJpaCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
        static class HasJpa {
            HasJpa() {
            }
        }

        @ConditionalOnBean(name={"hazelcastInstance"})
        static class HasHazelcastInstance {
            HasHazelcastInstance() {
            }
        }
    }

    private static class HazelcastInstanceJpaDependencyPostProcessor
    extends EntityManagerFactoryDependsOnPostProcessor {
        HazelcastInstanceJpaDependencyPostProcessor() {
            super("hazelcastInstance");
        }
    }
}

